package collect;

import java.util.Iterator;

public class Counter implements Iterator<Integer> {

	private final Integer lastElement;
	
	public Counter(Integer lastElement) {
		this(0,lastElement);
	}

	public Counter(Integer from, Integer lastElement) {
		if (from==null || lastElement == null || from >= lastElement) throw new IllegalArgumentException();
		this.lastElement = lastElement;
		next = from;
	}

	private Integer next;

	@Override public boolean hasNext() { return next<=lastElement; }

	@Override public Integer next() { return next++; }

	@Override public void remove() { throw new UnsupportedOperationException(); }

}
