package collect;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class TemporaryTerms<T> implements SortedSet<SortedSet<T>> {
	
	public static <T> TemporaryTerms<T> make(SortedSet<SortedSet<T>> from) {
		return new TemporaryTerms<T>(from);
	}

	private final SortedSet<SortedSet<T>> base;
	private final SortedSet<SortedSet<T>> temp;
	
	public boolean add(SortedSet<T> e) {
		return base.add(e);
	}

	public boolean addAll(Collection<? extends SortedSet<T>> c) {
		return base.addAll(c);
	}

	public void clear() {
		base.clear();
	}

	public Comparator<? super SortedSet<T>> comparator() {
		return base.comparator();
	}

	public boolean contains(Object o) {
		return base.contains(o);
	}

	public boolean containsAll(Collection<?> c) {
		return base.containsAll(c);
	}

	public boolean equals(Object o) {
		return base.equals(o);
	}

	public SortedSet<T> first() {
		return base.first();
	}

	public int hashCode() {
		return base.hashCode();
	}

	public SortedSet<SortedSet<T>> headSet(SortedSet<T> toElement) {
		return base.headSet(toElement);
	}

	public boolean isEmpty() {
		return base.isEmpty();
	}

	public Iterator<SortedSet<T>> iterator() {
		return base.iterator();
	}

	public SortedSet<T> last() {
		return base.last();
	}

	public boolean remove(Object o) {
		return base.remove(o);
	}

	public boolean removeAll(Collection<?> c) {
		return base.removeAll(c);
	}

	public boolean retainAll(Collection<?> c) {
		return base.retainAll(c);
	}

	public int size() {
		return base.size();
	}

	public SortedSet<SortedSet<T>> subSet(SortedSet<T> fromElement,
			SortedSet<T> toElement) {
		return base.subSet(fromElement, toElement);
	}

	public SortedSet<SortedSet<T>> tailSet(SortedSet<T> fromElement) {
		return base.tailSet(fromElement);
	}

	public Object[] toArray() {
		Object[] result = base.toArray(new Object[base.size()+temp.size()]);
		int i = base.size();
		for (SortedSet<T> extra : temp) result[i++] = extra;
		return result;
	}

	public <U> U[] toArray(U[] a) {
		
		return base.toArray(a);
	}

	private TemporaryTerms(SortedSet<SortedSet<T>> base) {
		this.base = base;
		temp = new TreeSet<SortedSet<T>>(base.comparator());
	}
	
}
