package test;

import static org.junit.Assert.*;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.junit.Before;

import base.Edge;
import base.FlexibleComponent;
import base.FlexibleComponents;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;


public class FlexibleComponentBothTest extends FlexibleComponentTest {

	static final List<? extends Set<Integer>> emptyList = ImmutableList.of(ImmutableSet.<Integer>of(), ImmutableSet.<Integer>of());
		
	@Before public void setUp() {
		testObject = FlexibleComponents.make(inhibitors,activators);
	}
		
	@Override public void testIsEmpty() {
		assertEquals(false, testObject.isEmpty());
	}

	@Override public void testSize() {
		assertEquals(activators.size() + inhibitors.size(), testObject.size());
	}

	@Override public void testContents() {
		for (Edge e : Edge.all) switch (e) {
			case TURN_ON : assertEquals(activators, testObject.get(e)); break;
			case TURN_OFF : assertEquals(inhibitors, testObject.get(e)); break;
			default : assertTrue(testObject.get(e).isEmpty()); break;
		}
	}
	
	@Override public void testEquals() { 
		assertEquals(testObject, FlexibleComponents.make(new HashSet<Integer>(inhibitors),new HashSet<Integer>(activators)));
	}

	@Override
	public void testAppendBoth() {
		Set<Integer> extraActivators = ImmutableSet.of(11,12);
		Set<Integer> extraInhibitors = ImmutableSet.of(9,10);
		FlexibleComponent other = FlexibleComponents.make(Sets.union(inhibitors, extraInhibitors), Sets.union(activators, extraActivators)); 
		assertEquals(other,testObject.append(extraInhibitors, extraActivators));
	}

	@Override
	public void testAppendOne() {
		Set<Integer> extraActivators = ImmutableSet.of(11,12);
		Set<Integer> extraInhibitors = ImmutableSet.of(9,10);
		FlexibleComponent otherI = FlexibleComponents.make(Sets.union(inhibitors, extraInhibitors), activators); 
		assertEquals(otherI,testObject.append(extraInhibitors, Edge.TURN_OFF));
		FlexibleComponent otherA = FlexibleComponents.make(inhibitors, Sets.union(activators, extraActivators)); 
		assertEquals(otherA,testObject.append(extraActivators, Edge.TURN_ON));
	}
	
}
