package test;

import static org.junit.Assert.assertSame;

import java.util.List;
import java.util.Set;

import org.junit.Test;

import base.FlexibleComponent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;


public abstract class FlexibleComponentTest {
	
	static final List<? extends Set<Integer>> emptyList = ImmutableList.of(ImmutableSet.<Integer>of(), ImmutableSet.<Integer>of());
	static final Set<Integer> activators = ImmutableSet.of(1,2);
	static final Set<Integer> inhibitors = ImmutableSet.of(3,4);
	static final List<? extends Set<Integer>> activateOnly = ImmutableList.of(ImmutableSet.<Integer>of(),activators);
	static final List<? extends Set<Integer>> inhibitOnly = ImmutableList.of(inhibitors,ImmutableSet.<Integer>of());
	static final List<? extends Set<Integer>> both = ImmutableList.of(inhibitors,activators);
	
	protected FlexibleComponent testObject;
			
	@Test public abstract void testIsEmpty();

	@Test public abstract void testSize();
	
	@Test public abstract void testContents();

	@Test public abstract void testEquals();

	@Test public void testAppend() {
		assertSame(testObject, testObject.append());
	}
	
	@Test public abstract void testAppendOne();
	
	@Test public abstract void testAppendBoth();
	
}
