//*******1*********2*********3*********4*********5*********6*********7*********8
// Main.java, Team B, http://code.google.com/p/ics340finalproject/ , Apr 2012
//
// 4/12/2012 - Ripley:	Cosmetic alterations to get used to the codebase and 
//						prepping for some basic support behaviors.
// 4/13/2012 - Ripley:	Integrating Main with the ICS340Final.class as per
//						requirement [17] from the spec doc.
//						ExceptionInInitializerErrors arrose due to static
//						references in the main class, class flow has 
//						been adjusted accordingly.

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * We start off by instantiating the all the applications in our project . Then
 * we set the current screen to test1 because this is our first tab in the
 * application. then we create a JTabbedPane to hold all of our
 * screens(Applications)
 * <p>
 * 
 * @author Simeon Gbolo
 * @modifier Jay Ripley
 * 
 */
public class Main extends JPanel {
	// Constant used for Tree labels, in case needs changing later.
	private static final String REDBLACK_TAB_TITLE = "RedBlack Tree";
	// Constant used for Tree labels, in case of changing later.
	private static final String REDBLACK_TAB_TOOLTIP = "Interact with a Red Black Tree";
	// Constant used for Tree labels, in case needs changing later.
	private static final String TWOFOUR_TAB_TITLE = "TwoFour Tree";
	// Constant used for Tree labels, in case of changing later.
	private static final String TWOFOUR_TAB_TOOLTIP = "Interact with a Two-Four Tree";
	// Constant used for Main Application Frame
	private static final String FRAME_TITLE = "Tree Rendering Toolkit";
	// Core TwoFour Tree Application behaviors here.
	private TwoFourApp twoFourApp;
	// Core RedBlack Tree Application behaviors here.
	private RedBlackApp redBlackApp;
	// Reference to main screen element displayed in the application.
	private Screen screen;
	// JTabbedPane Inner Class used to manage paging behaviors in UI.
	private JTabbedPane tabbedPane;

	// Applet Execution Flag, used to determine JFrame closure behavior.

	/*
	 * Constructors
	 */

	/**
	 * Default Constructor
	 */
	public Main()
	{
		// Prepare the TwoFour App.
		twoFourApp = new TwoFourApp();
		// Prepare the RedBlackApp.
		redBlackApp = new RedBlackApp();
		// Set the Default Screen
		screen = redBlackApp.getCurrentScreen();
		// Construct the main UI.
		display();
	}

	/*
	 * Public Methods
	 */

	/**
	 * Renders GUI and begins animation loops for the System. Seperated from the
	 * main Constructor due to cross-execution behaviors.
	 */
	public void display()
	{
		createAndShowGUI();
		startScreens();
	}

	/**
	 * Create the GUI and show it. For thread safety, this method should be
	 * invoked from the event dispatch thread.(only if your running the
	 * application version)
	 */
	private void createAndShowGUI()
	{
		// commented out due to a possible implementation of an
		// application version vs JApplet
		/*
		 * //Create and set up the window. JFrame frame = new
		 * JFrame(Main.FRAME_TITLE);
		 * 
		 * try { frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); } catch
		 * (Exception e) {
		 * frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE); }
		 * 
		 * //Add content to the window. frame.add(new Tabs(this),
		 * BorderLayout.CENTER);
		 * 
		 * //Display the window. frame.pack(); frame.setVisible(true);
		 */
		add(new Tabs(this));
	}

	/**
	 * * Within the Application main rendering loop, we calculate the delta
	 * time. This is the time that has passed since the beginning of the last
	 * frame. We then record the time of the beginning of the current frame. For
	 * the screen, the delta time indicates how much time has passed since it
	 * was last updatedinformation that is needed if we want to do
	 * frame-independent movement
	 * 
	 * <p>
	 * Lastly, all we do is simply update the current screens state and present
	 * it to the user. The update depends on the delta time as well as the input
	 * state, So we must provide those to the screen
	 * <p>
	 * And that is basically how this process works at a high level(Many games
	 * are also implemented this way ) . Process the user input, update the
	 * state, present the state to the user, and repeat ad infinitum (or until
	 * the user Wants to quit the application).
	 */
	private void startScreens()
	{

		// Turn off metal's use of bold fonts
		Runnable r = new Runnable() {
			public void run()
			{
				long startTime = System.nanoTime();
				while (true)
				{
					float deltaTime = (System.nanoTime() - startTime) / 1000000000.0f;
					startTime = System.nanoTime();

					screen.update(deltaTime);
					screen.present(deltaTime);

					try
					{
						Thread.sleep(1);
					} catch (InterruptedException e)
					{
						System.err.println("InterruptedException Occured");
						break;
					}
				}
			}
		};

		Thread t = new Thread(r);
		t.start();

	}

	/*
	 * Private and Inner Classes
	 */

	/**
	 * our Tabs class sets up all our tabs and the content for our tabs(content
	 * comes from test1.getTheGui() method)
	 * 
	 * @author Simeon Gbolo
	 * 
	 */
	public class Tabs extends JPanel implements ChangeListener {
		Main core_application; // req'd for later reference in ChangeListener.

		/**
		 * Disallowing access to the default constructor. References get strange
		 * without statics all over the place. Provide a reference to the main
		 * application so it can access screen objects - Ripley
		 */
		private Tabs() throws IllegalAccessException
		{
			String ex_msg = "Must provide reference to main application instance,"
					+ " use Tabs(Main core_application) to instantiate.";
			throw new IllegalAccessException(ex_msg);
		}

		/**
		 * Accepts a Main class instance, ties the JTabbedPane
		 * 
		 * @param the_application
		 *            Reference to a Main class instance.
		 */
		public Tabs(Main the_application)
		{
			super(new GridLayout(1, 1));

			setApplicationRef(the_application);

			// Tying the newly created Tab pane to the main application.
			JTabbedPane tabbedPane = new JTabbedPane();
			getApplicationRef().tabbedPane = tabbedPane;

			// add animation test 1 tab
			tabbedPane.addTab(Main.REDBLACK_TAB_TITLE, null,
					getApplicationRef().redBlackApp.getTheGui(),
					Main.REDBLACK_TAB_TOOLTIP);
			tabbedPane.setMnemonicAt(0, KeyEvent.VK_1);

			// add animation test 2 tab
			tabbedPane.addTab(Main.TWOFOUR_TAB_TITLE, null,
					getApplicationRef().twoFourApp.getTheGui(),
					Main.TWOFOUR_TAB_TOOLTIP);
			tabbedPane.setMnemonicAt(1, KeyEvent.VK_2);

			// now add change listener to all the tabs
			tabbedPane.addChangeListener(this);

			// add tabed pane to the panel
			add(tabbedPane);

			// The following line enables to use scrolling tabs.
			tabbedPane.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
		}

		/**
		 * Gets the reference for the main application for the Tabs class. Used
		 * as a method call to make the behavior conspicuous.
		 * 
		 * @return the main application reference for these Tabs.
		 * @author Ripley
		 */
		private Main getApplicationRef()
		{
			return core_application;
		}

		/**
		 * Sets the reference for the main application for the Tabs class. Used
		 * as a method call to make the behavior conspicuous.
		 * 
		 * @param the_application
		 *            A reference to a Main application Instance.
		 * @author Ripley
		 */
		private void setApplicationRef(Main the_application)
		{
			core_application = the_application;
		}

		/**
		 * If the tab has changed all we have to do is call this method to
		 * change the screen (as shown below) and the application will start
		 * rendering according to that screen
		 */
		@Override
		public void stateChanged(ChangeEvent e)
		{
			if (tabbedPane.getSelectedIndex() == 0)
			{
				getApplicationRef().screen = getApplicationRef().redBlackApp
						.getCurrentScreen();
			}

			if (tabbedPane.getSelectedIndex() == 1)
			{
				getApplicationRef().screen = getApplicationRef().twoFourApp
						.getCurrentScreen();
			}
		}
	}
}