import java.awt.Graphics;

import javax.swing.JPanel;

/*================================
 Author     		 : Simeon Gbolo
 Abstract Class Name : Screen
 Date       		 :   4/6/2012    
 Course     		 : ICS 340 Data Structures (Siva Jasthi)
 Purpose    		 : Assignment 4
 =================================*/

/**
 * We make it an abstract class instead of an interface so we can already
 * implement some bookkeeping that would be used through out the life time of
 * the application .
 * <p>
 * This way we have to write less code in the actual implementations of the
 * abstract Screen class
 * <p>
 * The constructor receives the <code> Application </code> instance and stores
 * it in a final member thats accessible to all subclasses. We do this becaues
 * we can acheve two important things!:
 * <p>
 * 1 .We can get access to the low-level modules of the
 * <code> Application </code> to draw to the screen and get user input.
 * <p>
 * 2. We can set a new current Screen by invoking
 * <code> Application.setScreen()</code> when appropriate (e.g., when a button
 * or tab is pressed that triggers a transition to a new screen).
 * 
 * <p>
 * 
 * The first point should be obvious: our Screen implementation needs access to
 * these low level modules so that it can actually do something meaningful, like
 * rendering 10,100,1000000 nodes or what ever you want on the screen.
 * <p>
 * The second point allows us to implement our screen transitions easily within
 * the Screen instances themselves. Each Screen can decide when to transition to
 * which other Screen based on its state (e.g., when a menu button was pressed).
 * 
 * @author simeon gbolo
 * 
 */
public abstract class Screen extends JPanel {
	/**
	 * protected final Member accessible to all subclasses so that application
	 * can change at runtime
	 */
	protected final Application application;

	public Screen(Application app)
	{
		this.application = app;
	}

	/**
	 * update the screen accordingly. The Application instance will call this
	 * once in each iteration of the the main loop.
	 * 
	 * @param deltaTime
	 *            information on how much time has passed since we last updated,
	 *            moved or rendered a graphical object(node, line ect...)
	 */
	public abstract void update(float deltaTime);

	/**
	 * present the screen it accordingly. The Application instance will call
	 * this once in each iteration of the the main loop.
	 * 
	 * @param deltaTime
	 *            information on how much time has passed since we last updated,
	 *            moved or rendered a graphical object(node, line ect...)
	 */
	public abstract void present(float deltaTime);

	/**
	 * will be called when the Application is paused. This is again done by the
	 * Application instance and applied to the currently active Screen in the
	 * main loop.
	 */
	public abstract void pause();

	/**
	 * You should all be very familiar with paint component from the last
	 * homework! - any screen you create must call this method to do the actual
	 * animation
	 */
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
	}
}