package loading;

import java.util.ArrayList;
import java.util.StringTokenizer;

import career.AcademicCareer;
import career.AcademicExam;

/**
 * Simple implementation of {@link Interpreter} that converts a string into
 * an exam. The resulting exam is then loaded in a proper list
 * 
 * @author simone
 *
 */
public class CsvStringToAcademicExam implements Interpreter {

	private AcademicCareer examList;

	public CsvStringToAcademicExam(AcademicCareer career) {
		super();
		this.examList = career;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see career.loading.StringToExam#loadExam(java.lang.String)
	 */
	@Override
	public void interpret(String string) {
		StringTokenizer tk = new StringTokenizer(string, ",");
		examList.addExam(new AcademicExam(tk.nextToken(), Integer.parseInt(tk
				.nextToken()), Integer.parseInt(tk.nextToken())));
	}
}
