package co.edu.udea.ingweb.inventariomoduloii.model;

/**
 * 
 * @author Yefry Alexis Caldern Yepes
 * @author Daniela Serna Buitrago
 * @version 1.0
 *
 *          Clase que representa la clave primaria de la tabla
 *          AlertaGeneradaHasProducto
 */
public class AlertaGeneradaHasProductoId implements java.io.Serializable {

	private int alertaGeneradaIdAlertaGenerada;
	private int productoIdProducto;
	private String productoBodega;

	public AlertaGeneradaHasProductoId() {
	}

	public AlertaGeneradaHasProductoId(int alertaGeneradaIdAlertaGenerada,
			int productoIdProducto, String productoBodega) {
		this.alertaGeneradaIdAlertaGenerada = alertaGeneradaIdAlertaGenerada;
		this.productoIdProducto = productoIdProducto;
		this.productoBodega = productoBodega;
	}

	public int getAlertaGeneradaIdAlertaGenerada() {
		return this.alertaGeneradaIdAlertaGenerada;
	}

	public void setAlertaGeneradaIdAlertaGenerada(
			int alertaGeneradaIdAlertaGenerada) {
		this.alertaGeneradaIdAlertaGenerada = alertaGeneradaIdAlertaGenerada;
	}

	public int getProductoIdProducto() {
		return this.productoIdProducto;
	}

	public void setProductoIdProducto(int productoIdProducto) {
		this.productoIdProducto = productoIdProducto;
	}

	public String getProductoBodega() {
		return this.productoBodega;
	}

	public void setProductoBodega(String productoBodega) {
		this.productoBodega = productoBodega;
	}

	public boolean equals(Object other) {
		if ((this == other))
			return true;
		if ((other == null))
			return false;
		if (!(other instanceof AlertaGeneradaHasProductoId))
			return false;
		AlertaGeneradaHasProductoId castOther = (AlertaGeneradaHasProductoId) other;

		return (this.getAlertaGeneradaIdAlertaGenerada() == castOther
				.getAlertaGeneradaIdAlertaGenerada())
				&& (this.getProductoIdProducto() == castOther
						.getProductoIdProducto())
				&& ((this.getProductoBodega() == castOther.getProductoBodega()) || (this
						.getProductoBodega() != null
						&& castOther.getProductoBodega() != null && this
						.getProductoBodega().equals(
								castOther.getProductoBodega())));
	}

	public int hashCode() {
		int result = 17;

		result = 37 * result + this.getAlertaGeneradaIdAlertaGenerada();
		result = 37 * result + this.getProductoIdProducto();
		result = 37
				* result
				+ (getProductoBodega() == null ? 0 : this.getProductoBodega()
						.hashCode());
		return result;
	}

}
