package co.edu.udea.ingweb.inventariomoduloii.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.List;

import org.junit.Test;

import co.edu.udea.ingweb.inventariomoduloii.dao.impl.DAOAlertaCreadaImpl;
import co.edu.udea.ingweb.inventariomoduloii.model.AlertaCreada;
import co.edu.udea.ingweb.inventariomoduloii.model.AlertaCreadaId;
import co.edu.udea.ingweb.inventariomoduloii.model.Usuario;

/**
 * 
 * @author Yefry Alexis Calder&oacute;n Yepes
 * @author Daniela Serna Buitrago
 * @version 1.0
 * 
 *          Clase que permite realizar pruebas sobre el modelo Usuario de la
 *          Base de Datos
 */
public class DAOAlertaCreadaImplTest {

	private DAOAlertaCreadaImpl daoAlertaCreadaImpl;

	/**
	 * Prueba al m&eacute;todo obtener alertas creadas de la base de datos de la
	 * clase DAOUserImp
	 */
	@Test
	public void testGetCreatedAlerts() {
		daoAlertaCreadaImpl = new DAOAlertaCreadaImpl();

		List<AlertaCreada> alertasEncontradas = daoAlertaCreadaImpl
				.getCreatedAlerts();

		//assertEquals(alertasEncontradas.size(), 0);
	}

	/**
	 * Prueba al m&eacute;todo obtener alerta creada de la base de datos de la
	 * clase DAOAlertaCreadaImpl
	 */
	@Test
	public void testGetCreatedAlert() {
		try {
			AlertaCreada alertaCreada = daoAlertaCreadaImpl.getCreatedAlert(1);
		} catch (Exception e) {
			// TODO: handle exception
		}
	}

	/**
	 * Prueba al m&eacute;todo guardar alertas creadas de la base de datos de la
	 * clase DAOAlertaCreadaImpl
	 */
	@Test
	public void testSaveCreatedAlert() {
		AlertaCreada alertaCreada = new AlertaCreada();
		alertaCreada.setId(new AlertaCreadaId(1, 1));
		alertaCreada.setUsuario(new Usuario(1, "Yefry", "admin",
				"alexis@gmail.com", "alexiscaldero", "1234"));
		alertaCreada.setBodega("Central");
		alertaCreada.setCantidadLimite(15);
		alertaCreada.setProducto("Arroz");

		try {
			daoAlertaCreadaImpl.saveCreatedAlert(alertaCreada);
		} catch (Exception e) {
			// TODO: handle exception
		}
	}

	/**
	 * Prueba al m&eacute;todo eliminar alertas creadas de la base de datos de la
	 * clase DAOAlertaCreadaImpl
	 */
	@Test
	public void testDeleteCreatedAlert() {

		try {
			daoAlertaCreadaImpl.deleteCreatedAlert(daoAlertaCreadaImpl
					.getCreatedAlert(1));
		} catch (Exception e) {
		}
		
	}

	/**
	 * Prueba al m&eacute;todo editar alertas creadas de la base de datos de la
	 * clase DAOAlertaCreadaImpl
	 */
	@Test
	public void testEditCreatedAlert() {
		try {
			daoAlertaCreadaImpl.editCreatedAlert(daoAlertaCreadaImpl
					.getCreatedAlert(1));
		} catch (Exception e) {
		}
	}

}
