/*
 * Component.java
 *
 * Created on November 27, 2007, 9:42 PM
 *
 */

package core;

import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import ui.AnimationCanvas;

/**
 *
 * @author Suraj Sapktoa [ ssapkota<at>gmail<dot>com ]
 * @version $Id:$
 */
public class Component implements Comparable{
    //the name of this component eg: head,neck...
    private String name=null;
    private AnimationCanvas ac=null;
    private Set<Surface> faces=null;
    private Point3D centre=null;
    private double distance=0;
    
    //This is the point used to calculate distance if the component is either of body or uppor_hands
    private Point3D shiftedCenter=null;
    
    /**Creates a new instance of Component
     */
    public Component(String name,AnimationCanvas ac,Set<Surface> faces,Point3D centre,Point3D extraPoint) {
        this.name=name;
        this.ac=ac;
        this.faces = faces;
        this.centre=centre;
        this.shiftedCenter=extraPoint;
        this.computeDistance();
    }
    public void computeDistance(){
        if(this.shiftedCenter!=null){
            this.distance=Math.sqrt(Math.pow(ac.getEyeX()-this.shiftedCenter.getX(),2)+
                                    Math.pow(ac.getEyeY()-this.shiftedCenter.getY(),2)+
                                    Math.pow(ac.getEyeZ()-this.shiftedCenter.getZ(),2));
        }
        else {
            this.distance=Math.sqrt(Math.pow(ac.getEyeX()-this.centre.getX(),2)+
                                    Math.pow(ac.getEyeY()-this.centre.getY(),2)+
                                    Math.pow(ac.getEyeZ()-this.centre.getZ(),2));
        }
                
    }
    public void paint(Graphics2D g2){
        Iterator iter=faces.iterator();
        System.out.print("\nPainting "+this.getName()+"...");
        int i=0;
        while(iter.hasNext()){
            System.out.print("\n\tPainting ");
            Surface surface=(Surface)iter.next();
            surface.paint(g2,this);
        }
    }
    
    public void move(float dx){
        if(this.shiftedCenter!=null) this.shiftedCenter.move(dx);
    }
    
    public Point3D getCentre() {
        return centre;
    }
    
    /**
     *This compares the component and helps in painting by arranging the components by their distance from the view point.
     *The far object(s) is/are painted before the nearer one.
     *@return A negative number if <em>this</em> component lies away from the <em>component (object) o</em> else returns a positive value.
     *<p><em>In case of equal distance we really dont have to bother about the painting order so we return a positive value (insted of zero). Component o is painted before
     *component.</em></p>
     */
    public int compareTo(Object o) {
        //System.out.println("Comparing ...");
        if(((Component) o).getDistance()<this.getDistance()) return -1;
        else return 1;
    }
    
    public String getName() {
        return name;
    }
    
    public void setName(String name) {
        this.name = name;
    }
    
    public double getDistance() {
        return distance;
    }
}
