/*
 * MathVector.java
 *
 * Created on December 4, 2007, 4:16 PM
 *
 */

package core;

/**
 * Data type that stores that components of a mathematics vector
 *
 * @author  Abhishek Dutta (adutta.np@gmail.com)
 * @version $Id: MathVector.java 17 2007-12-11 16:16:47Z thelinuxmaniac $
 */

public class MathVector {
    // components of the vector
    private float i;
    private float j;
    private float k;
    
    /** Creates a new instance of MathVector */
    public MathVector() {
        i = 0.0F;
        j = 0.0F;
        k = 0.0F;
    }
    
    public MathVector(float i, float j, float k)    {
        this.i = i;
        this.j = j;
        this.k = k;
    }
    
    public MathVector(int i, int j, int k)  {
        this.i = i;
        this.j = j;
        this.k = k;
    }

    public MathVector(MathVector v) {
        this.i = v.getI();
        this.j = v.getJ();
        this.k = v.getK();
    }
    
    /**
     * performs division of the vector by a magnitude and returns a new vector
     */
    public MathVector divide(float magnitude)   {
        MathVector t = new MathVector(i/magnitude, j/magnitude, k/magnitude);
        return t;
    }
    
    /**
     * returns the unit vector of this vector
     */
    public MathVector getUnitVector()   {
        float mag = (float) Math.sqrt( (double) (i*i + j*j + k*k));
//        MathVector v = new MathVector(Math.round(i/mag), Math.round(j/mag), Math.round(k/mag));
        MathVector v = new MathVector(i/mag, j/mag, k/mag);
        return v;        
    }
    
    /**
     * performs dot product operation on two vectors
     */
    public static float dotProduct(MathVector v1, MathVector v2)  {
        float dotP = v1.getI()*v2.getI() + v1.getJ()*v2.getJ() + v1.getK()*v2.getK();
        return dotP;
    }
    
    /**
     * performs cross product operation on two vectors
     */
    public static MathVector crossProduct(MathVector v1, MathVector v2)  {
        MathVector crossP = new MathVector();
        crossP.setI(v1.getJ()*v2.getK() - v1.getK()*v2.getJ());
        crossP.setJ(- (v1.getI()*v2.getK() - v2.getI()*v1.getK()));
        crossP.setK(v1.getI()*v2.getJ() - v1.getJ()*v2.getI());
        return crossP;
    }

    public String toString() {
        String s ="[ "+getI()+"i "+getJ()+"j "+getK()+"k ]";
        return s;
    }
    
    public float getI() {
        return i;
    }

    public void setI(float i) {
        this.i = i;
    }

    public float getJ() {
        return j;
    }

    public void setJ(float j) {
        this.j = j;
    }

    public float getK() {
        return k;
    }

    public void setK(float k) {
        this.k = k;
    }
}
