/*
 * ControlPanel.java
 *
 * Created on December 3, 2007, 11:49 AM
 *
 */

package ui;

import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JPanel;

/**
 * displays the control buttons for the animation
 *
 * @author  Abhishek Dutta (adutta.np@gmail.com)
 * @version $Id: ControlPanel.java 36 2008-01-06 12:06:25Z thelinuxmaniac $
 */

public class ControlPanel extends JPanel    {
    // reference to main panel
    private MainPanel mainPanel;
    
    private ViewPointControlPanel viewPointControlPanel;
        
    private JButton startButton;
    private JButton walkButton;
    private JButton exitButton;
    private JButton restartWalkButton;
    private JButton vpPlus;
    private JButton vpMinus;
    
    private javax.swing.JTextField zprpField;
    private javax.swing.JLabel zprpLabel;
    private javax.swing.JTextField walkSpeedField;
    private javax.swing.JLabel walkSpeedLabel;
    
    /** Creates a new instance of ControlPanel */
    public ControlPanel(MainPanel mp) {
        this.mainPanel = mp;
        viewPointControlPanel = new ViewPointControlPanel(mainPanel);
        
//        setBackground(new java.awt.Color(242, 242, 242));
        setBackground(new java.awt.Color(255, 255, 255));
        setMaximumSize(new java.awt.Dimension(800, 100));
        setMinimumSize(new java.awt.Dimension(800, 100));
        setPreferredSize(new java.awt.Dimension(800, 100));
        
        
        
        startButton = new JButton("Draw");
        startButton.setToolTipText("Draw Robot");
        startButton.setActionCommand("ControlPanel-Draw");
        startButton.setContentAreaFilled(false);
        startButton.setMnemonic('a');
        startButton.addActionListener(mainPanel);
        
        walkButton = new JButton("Walk");
        walkButton.setToolTipText("Start Walking Animation");
        walkButton.setActionCommand("ControlPanel-Walk");
        walkButton.setMnemonic('w');
        walkButton.setContentAreaFilled(false);
        walkButton.addActionListener(mainPanel);

        exitButton = new JButton("Exit");
        exitButton.setToolTipText("Exit");
        exitButton.setActionCommand("ControlPanel-Exit");
        exitButton.setContentAreaFilled(false);
        exitButton.setMnemonic('x');
        exitButton.addActionListener(mainPanel);
        
        restartWalkButton = new JButton("Reset");
        restartWalkButton.setToolTipText("Exit");
        restartWalkButton.setActionCommand("ControlPanel-RestartWalk");
        restartWalkButton.setContentAreaFilled(false);
        restartWalkButton.setMnemonic('e');
        restartWalkButton.setEnabled(false);
        restartWalkButton.addActionListener(mainPanel);
        
        vpPlus = new JButton();
        vpPlus.setIcon(new javax.swing.ImageIcon(getClass().getClassLoader().getResource("resources/images/plus.png")));
        vpPlus.setRolloverIcon(new javax.swing.ImageIcon(getClass().getClassLoader().getResource("resources/images/plus_roll.png")));
        vpPlus.setMnemonic('P');
        vpPlus.setActionCommand("ViewPoint-Plus");
        vpPlus.setToolTipText("Move View Point Into the screen (deeper)");
        vpPlus.setBorderPainted(false);
        vpPlus.setContentAreaFilled(false);
        vpPlus.setRolloverEnabled(true);
        vpPlus.setMinimumSize(new Dimension(29,21));
        vpPlus.setPreferredSize(new Dimension(29,21));
        vpPlus.addActionListener(mainPanel);
        
        vpMinus = new JButton();
        vpMinus.setIcon(new javax.swing.ImageIcon(getClass().getClassLoader().getResource("resources/images/minus.png")));
        vpMinus.setRolloverIcon(new javax.swing.ImageIcon(getClass().getClassLoader().getResource("resources/images/minus_roll.png")));
        vpMinus.setMnemonic('M');
        vpMinus.setActionCommand("ViewPoint-Minus");
        vpMinus.setToolTipText("Move View Point off the screen (outer)");
        vpMinus.setBorderPainted(false);
        vpMinus.setContentAreaFilled(false);
        vpMinus.setRolloverEnabled(true);
        vpMinus.setMinimumSize(new Dimension(29,21));
        vpMinus.setPreferredSize(new Dimension(29,21));
        vpMinus.addActionListener(mainPanel);
        
        walkSpeedField = new javax.swing.JTextField(3);
        zprpField = new javax.swing.JTextField();
        walkSpeedLabel = new javax.swing.JLabel("Walk Speed (1 FASTEST) ");
        zprpLabel = new javax.swing.JLabel("Zprp");
        
        walkSpeedField.setText("3");
        zprpField.setText("3");
        walkSpeedField.addFocusListener(new FocusListener() {
            public void focusGained(FocusEvent e) {
            }
            public void focusLost(FocusEvent e) {
                if(mainPanel.getAnimationCanvas().getRobot().isRobotWalking())  {
                    mainPanel.getAnimationCanvas().getRobot().setRobotWalking(false);
                    mainPanel.getAnimationCanvas().getRobot().setWalkingSpeed(Integer.parseInt(getWalkSpeedField().getText())*100);
                    mainPanel.getAnimationCanvas().getRobot().setRobotWalking(true);
                }
                else
                    mainPanel.getAnimationCanvas().getRobot().setWalkingSpeed(Integer.parseInt(getWalkSpeedField().getText())*100);
            }
        });
        
//        walkSpeedLabel.setVisible(false);
//        walkSpeedField.setVisible(false);
        zprpLabel.setVisible(false);
        zprpField.setVisible(false);
        
       
        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(walkSpeedLabel)
                    .addComponent(zprpLabel))
                .addGap(15, 15, 15)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(walkSpeedField)
                    .addComponent(zprpField, javax.swing.GroupLayout.DEFAULT_SIZE, 48, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 38, Short.MAX_VALUE)
                .addComponent(viewPointControlPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(vpPlus)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 29, Short.MAX_VALUE)
                        .addComponent(startButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(walkButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(restartWalkButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(exitButton))
                    .addComponent(vpMinus))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(exitButton)
                            .addComponent(restartWalkButton)
                            .addComponent(walkButton)
                            .addComponent(startButton)
                            .addComponent(vpPlus))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 38, Short.MAX_VALUE)
                        .addComponent(vpMinus))
                    .addComponent(viewPointControlPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(walkSpeedLabel)
                            .addComponent(walkSpeedField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(zprpLabel)
                            .addComponent(zprpField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
        );
    }

    public javax.swing.JTextField getZprpField() {
        return zprpField;
    }

    public void setZprpField(javax.swing.JTextField zprpField) {
        this.zprpField = zprpField;
    }

    public javax.swing.JTextField getZvpField() {
        return walkSpeedField;
    }

    public void setZvpField(javax.swing.JTextField zvpField) {
        this.walkSpeedField = zvpField;
    }

    public JButton getRestartWalkButton() {
        return restartWalkButton;
    }

    public javax.swing.JTextField getWalkSpeedField() {
        return walkSpeedField;
    }
}
