/*
 * IntroLogoPanel.java
 *
 * Created on August 12, 2007, 6:03 PM
 *
 */

package ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.*;

/**
 * Displays the Panel with iRobot 
 *
 * @author  Abhishek Dutta (adutta.np@gmail.com)
 */
public class IntroLogoPanel extends JPanel  {
    
    private MainPanel mainPanel;
    private int logoX;
    private int logoY;
    
    /** Creates a new instance of IntroLogoPanel */
    public IntroLogoPanel(MainPanel mp) {
        this.mainPanel = mp;
        
        setPreferredSize(new Dimension(1280,1024));
        setMinimumSize(new Dimension(800,600));
        setMaximumSize(new Dimension(800,600));
        
        setBackground(Color.WHITE);
    }
    
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHints(mainPanel.getAnimationCanvas().getHintForQualityProcessing());
        
        // Shadow drop and anti-aliasing is done for the graphic objects in "hintForQualityProcessing" mode
        // No Shadow or anti-aliasing is done for the graphic objects in "hintForSpeedProcessing" mode
        
        // draw gradient in background
        g2.setPaint(new GradientPaint(400,0,Color.BLACK,400,600,Color.WHITE));
        g2.fillRect(0,0,getSize().width, getSize().height);

        g2.setFont(g2.getFont().deriveFont(92.0F));
        g2.setColor(Color.YELLOW);
        g2.drawString("iRobot",getSize().width/2 -140,120);
                    
        g2.setFont(g2.getFont().deriveFont(32.0F));
        g2.setColor(Color.DARK_GRAY);
        g2.drawString("http://irobot-graphics.googlecode.com",getSize().width/2 -300,420);
        
        g2.setFont(g2.getFont().deriveFont(24.0F));
        g2.setColor(Color.WHITE);
        g2.drawString("the walking robot",getSize().width/2 -100,160);
        
        
        g2.setColor(new Color(0,0,0));        
        g2.drawString("Abhishek Dutta",getSize().width/20,getSize().height - getSize().height/6);
        g2.drawString("Suraj Sapkota",getSize().width - getSize().width/4,getSize().height - getSize().height/6);
        
        g2.setFont(g2.getFont().deriveFont(16.0F));
        g2.drawString("061BCT501",getSize().width/20,getSize().height - getSize().height/6 +30);
        g2.drawString("061BCT543",getSize().width - getSize().width/4,getSize().height - getSize().height/6 +30);
        
        g2.drawString("adutta.np@gmail.com",getSize().width/20,getSize().height - getSize().height/6+60);
        g2.drawString("ssapkota@gmail.com",getSize().width - getSize().width/4,getSize().height - getSize().height/6+60);
        
        // release any system resources used by this graphics
//        g2.dispose();
    }
    
    
    public int getLogoY() {
        return logoY;
    }
    
    public void setLogoY(int logoY) {
        this.logoY = logoY;
    }
    
    public int getLogoX() {
        return logoX;
    }
    
    public void setLogoX(int logoX) {
        this.logoX = logoX;
    }
}
