/*
 * Main.java
 *
 * Created on December 3, 2007, 11:19 AM
 *
 */

package ui;

import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * Main Entry class for iRobot
 *
 * @author  Abhishek Dutta (adutta.np@gmail.com)
 * @version $Id: Main.java 28 2008-01-04 14:50:52Z thelinuxmaniac $
 */

public class Main implements KeyListener    {
    private JFrame frame;
    private MainPanel mainPanel;
    private IntroLogoPanel introLogoPanel;
    private CardLayout cardManager;
    private JPanel irobotContentsPanel;
    
    /** Creates a new instance of Main */
    public Main() {
        frame = new JFrame("iRobot");
        frame.setPreferredSize(new Dimension(1280,1024));
        frame.setMinimumSize(new Dimension(800,600));
        frame.setMaximumSize(new Dimension(800,600));
        frame.setResizable(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        // initialize the panel that will contain all the game contents
        irobotContentsPanel = new JPanel();
        cardManager = new CardLayout();
        irobotContentsPanel.setLayout(cardManager);
        
        mainPanel = new MainPanel(this);
        irobotContentsPanel.add(mainPanel, "MainPanel");
        
        introLogoPanel = new IntroLogoPanel(mainPanel);
        irobotContentsPanel.add(introLogoPanel,"IntroLogoPanel");
        frame.addKeyListener(this);

        showFrame();
    }
    
    private void showFrame() {
//        frame.setUndecorated(true);
        frame.getContentPane().add(irobotContentsPanel);
        frame.pack();
        frame.setVisible(true);
        
        mainPanel.getAnimationCanvas().setRedrawCanvas(true);
        cardManager.show(irobotContentsPanel, "IntroLogoPanel");
        try {
            Thread.sleep(1000);
        } catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
    
    public static void main(String[] args) {
        Main anim = new Main();
    }
    
    public JFrame getFrame() {
        return frame;
    }
    
    public void setFrame(JFrame frame) {
        this.frame = frame;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        cardManager.show(irobotContentsPanel, "MainPanel");
    }

    public void keyReleased(KeyEvent e) {
    }
    
}
