package no.ntnu.it1901.resturant.Objecter;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.Collator;
import java.util.Locale;

/**
 * managing Dishes to make it easier to handle the information from the database
 * 
 * @author Glover
 * @author Arnfinn
 * @version 1.2 12.11.2010
 * @since java 1.6
 *
 */

public class DishOb implements Comparable {
	
	private double pris = -1;
	private String rettnavn = "NONAME";
	private String kommentar = "NOCOMMENT";
	private int rettId = -1;
	
	/**
	 * 
	 * creates a dishOb without rettId
	 * 
	 * @param pris
	 * @param rettnavn
	 * @param comment
	 */
	
	public DishOb(double pris, String rettnavn, String comment){
		this.pris = pris;
		this.rettnavn = rettnavn;
		this.kommentar = comment;
	}
	/**
	 * creates a complete dishOb
	 * 
	 * @param pris
	 * @param rettnavn
	 * @param kommentar
	 * @param rettId
	 */
	public DishOb(double pris, String rettnavn, String kommentar, int rettId){
		this.pris = pris;
		this.kommentar = kommentar;
		this.rettnavn = rettnavn;
		this.rettId = rettId;
	}
	
	/**
	 * sorts dishOb by dishName in alfabetical order
	 * 
	 * @param dishes array, all the dishes you want sorted
	 * @return Dish array sorted by dishName(rettnavn)
	 */

	public static DishOb[] sort(DishOb[] dishes) {
		java.util.Arrays.sort(dishes);
		return dishes;
	}
	
	/**
	 * toString method that returns the name of the dish.
	 * 
	 * @return String with rettnavn
	 */
	public String toString(){
		return rettnavn  /*+ ", " + pris + ", " + kommentar  + "."*/;
	}

	public double getPris() {
		return pris;
	}

	public String getRettnavn() {
		return rettnavn;
	}

	public String getKommentar() {
		return kommentar;
	}

	public int getRettId() {
		return rettId;
	}
	/**
	 * updates the rettId in the object
	 * used when creating a new dish in the adminPanel
	 * 
	 * @param newId
	 */
	public void setRettId(int newId){
		rettId=newId;
	}
	
	/**
	 * implemented method for sorting
	 * 
	 * @see Comparable.compareTo
	 * @param Dish
	 */
	public int compareTo(Object Dish) {
		Collator col = Collator.getInstance(Locale.getDefault());
		int result = col.compare(this.rettnavn,(((DishOb) Dish).rettnavn));
		return result;
		
	}

	
}
