package no.ntnu.it1901.resturant.Objecter;

import java.util.ArrayList;

import no.ntnu.it1901.resturant.database.Order;
import no.ntnu.it1901.resturant.database.Dish;
/**
 * managing Orders to make it easier to handle the information from the database
 * 
 * @author Glover
 * @author Arnfinn
 * @version 1.51 12.11.2010
 * @since java 1.6
 *
 */

public class OrderOb implements Comparable {
	private int bestillingId = -1;
	private int kundeId = -1;
	private String dato;
	private int[] matretter;
	private int utfort = 0;
	private int levert = 0;
	private int skalLeveres = 1;
	private String kommentar = "Ingen kommentar";


	/**
	 * creates a compleat object
	 * 
	 * @param bestillingId
	 * @param kundeId
	 * @param dato
	 * @param matretter
	 * @param utfort
	 * @param levert
	 * @param kommentar
	 */
	public OrderOb(int bestillingId, int kundeId, String dato, int[] matretter, int utfort, int levert, String kommentar){
		this.bestillingId = bestillingId;
		this.kundeId = kundeId;
		this.dato = dato;
		this.matretter=matretter;
		this.utfort = utfort;
		this.levert = levert;
		if(kommentar!=null){
			this.kommentar = kommentar;
		}
	}
	
	
	/**
	 * Implemented method for sorting the object based on the time.
	 * 
	 * @param bestilling1
	 * @return int -1 0 or 1
	 */
	public int compareTo(Object bestilling1) {
			long tid1 = Time(((OrderOb)bestilling1).dato);
			long tid2 = Time(this.dato);
			if (tid1<tid2){
				return 1;	
			}
			else if (tid1==tid2){
				return 0;
			}
			else {
				return -1;
			}
	}
	/**
	 * the method parses a string which is made in the form of a date 
	 * and makes it into the datatype long
	 * 
	 * @param datoS
	 * @return long
	 */
	public static long Time(String datoS) {
		int lengde = datoS.length();
		int j;
		String tidS = "";
		for(int i = 0; i < lengde; i++){
			try{
				String a = "" +datoS.charAt(i);
				j = Integer.parseInt(a);
				tidS += j;
			}
			catch(NumberFormatException e) {
			}
			
		}
		long tid = Long.parseLong(tidS);
		return tid;	
	}
	/**
	 * toString method that prints out all the dish namnes connected to the order
	 * 
	 * @return String
	 */

		
	public String toString(){

	/*
	 * the method is made simple so that editing the method is simpler.
	 * making it easier to add/remove information like time or comment to the String
	 */
		
		return matrettString() +  " ";
	}
	
/**
 * helping method for toString()
 * The method handles the logic operations for counting the number of similar dishes in the order.
 * 
 * @return String a long string with count + dish name for every distinct dish in the order
 * 
 */

	private String matrettString(){
		int posisjon;
		int antallT;
		ArrayList <Integer> tempId = new ArrayList();
		ArrayList <Integer> tempAntall = new ArrayList();
		String result = " ";
		String organize;
		
		if(matretter != null){
			/*
			 * the for loop will traverse through all the dishes in the order
			 * and counts the number of times it occurs
			 */
			for (int i = 0; i < matretter.length; i++){
				if(tempId.contains(matretter[i])){
					posisjon = tempId.indexOf(matretter[i]);
					antallT = tempAntall.get(posisjon);
					antallT++;
					tempAntall.remove(posisjon);
					tempAntall.add(posisjon, antallT);
					
				}
				else{
					antallT = 1;
					tempId.add(matretter[i]);
					tempAntall.add(antallT);
				}
			}
			for (int i = 0; i < tempId.size() - 1; i++){
				organize = matrettStrengOrganizer(tempAntall.get(i) + " " +
						Dish.finnRettNavn(tempId.get(i)));
				result += organize + "-- ";
			}
			/*
			 *  in order to avoid adding the "-- " to the last subString
			 *  the last subString is created outside the loop
			 */
			if (tempId.size() != 0 ) {
			organize = matrettStrengOrganizer(tempAntall.get(tempId.size()-1) + " "
					+ Dish.finnRettNavn(tempId.get(tempId.size()-1)));
			result += organize;
			}
			
		}
	
		return result;
		}
	
	/**
	 * helping method for toString() for aligning purposes.
	 * 
	 * @param String
	 * @return String with added space, much like a tab function.
	 */
	private String matrettStrengOrganizer(String matrett){
		int offset =  20 - matrett.length()%20;
		for (int i = 0; i < offset; i++){
			matrett+= " ";
		}
		return matrett;
		
	}
		
	
	public int getBestillingId() {
		return bestillingId;
	}
	public int getKundeId() {
		return kundeId;
	}
	public String getDato() {
		return dato;
	}
	public int[] getMatretter() {
		return matretter;
	}
	public int getUtfort() {
		return utfort;
	}
	public int getLevert() {
		return levert;
	}
	public String getKommentar() {
		return kommentar;
	}
	public int getSkalLeveres(){
		return skalLeveres;
	}
	public void setLevert() {
		Order.settLevertBestilling(this.bestillingId);
	}
	public void setFerdig() {
		Order.settFerdigBestilling(this.bestillingId);
	}


	
}
