package no.ntnu.it1901.resturant.UI.Delivery;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.other.PrintLine;
/**
 * This class tells you in a panel what orders are ready for delivery,
 * includes extended information on picked order,
 * buttons to refresh and tell database to mark picked order as delivered. 
 * 
 * @see Jpanel
 */
public class DeliveryOrderPanel extends JPanel implements PanelAdjustment, ListSelectionListener, ActionListener {
	//Parent Panel
	DeliveryPanel deliveryPanel;
	
	JButton bMarkedDelivered;
	JButton bRefresh;
	JTextArea orderInfo;
	JList orders;
	JScrollPane ordersScroll;
	int pickedItem = 0;
	
	final static String sMarkedDelivered = "Merk som levert";
	final static String sRefresh = "Oppdater";
	
	public DeliveryOrderPanel(DeliveryPanel deliveryPanel) {
		super();
		
		this.deliveryPanel = deliveryPanel;
		setBackground(Color.CYAN);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Disable layout
		setLayout(null);
		
		addComponents();
	}


	/**
	 * Adds components to the panel,
	 * orderScroll, orderInfo, refresh, markedDelivered
	 */
	private void addComponents() {
		
		orders = new JList(new String[] {"Waiting for orders", "Test"});
		orders.setFont(MainGUI.FONT);
		orders.addListSelectionListener(this);
		ordersScroll = new JScrollPane(orders);
		orderInfo = new JTextArea("");
		Font f = new Font(MainGUI.FONT.getFontName(), MainGUI.FONT.getStyle(), (int)(MainGUI.FONT.getSize()*1.2));
		orderInfo.setFont(f);
		orderInfo.setEditable(false);
		
		//Button to mark a order as delivered(unactive until you chose a order)
		bMarkedDelivered = new JButton(sMarkedDelivered);
		bMarkedDelivered.addActionListener(this);
		bMarkedDelivered.setEnabled(false);
		
		bRefresh = new JButton(sRefresh);
		bRefresh.addActionListener(this);
		
		add(ordersScroll);
		add(orderInfo);
		add(bRefresh);
		add(bMarkedDelivered);
		
	}
	
	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub
		
	}

	/**
	 * When JFrame resizes it sends the new size for this JPanel,
	 * use it manage scaling of the panel
	 * 
	 * @param width
	 * @param height
	 */
	public void resizePanel(int width, int height) {
		int buttonHeight = 60;
		ordersScroll.setBounds(0, 0, width, height/2);
		orderInfo.setBounds(0, height/2, width, (height/2) - buttonHeight);
		bRefresh.setBounds(width/2, height-buttonHeight, width/2, buttonHeight);
		bMarkedDelivered.setBounds(0, height-buttonHeight, width/2, buttonHeight);
		
	}
	
	//ListSelectionListener
	/**
	 * List listener for JList, sets pickedItem to the index of picked order,
	 * and tells deliveryPanel who we picked
	 * 
	 * @param e
	 */
	public void valueChanged(ListSelectionEvent e) {
		if(e.getValueIsAdjusting()){ //Picks costumer on click and not on release of click
			pickedItem = ((JList)e.getSource()).getSelectedIndex();
			PrintLine.println("Selected item in ChefPanel: " + pickedItem);
			deliveryPanel.action(DeliveryPanel.PICKED_CUSTOMER);
			bMarkedDelivered.setEnabled(true);
		}
		
	}

	/**
	 * Button listener for refresh and markedDelivered buttons,
	 * informs deliveryPanel if they are used
	 * 
	 * @param e
	 */
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() instanceof JButton){
			PrintLine.println("Pressed Button in PickedCustomerPanel: " + ((JButton)e.getSource()).getText());
			if(e.getSource() == bMarkedDelivered){
				deliveryPanel.action(DeliveryPanel.DELIVERED);	
				PrintLine.println("Selected button in DeliveryPanel: " + bMarkedDelivered);
				bMarkedDelivered.setEnabled(false);
			}
			else if(e.getSource() == bRefresh){
				deliveryPanel.action(DeliveryPanel.REFRESH);	
				PrintLine.println("Selected button in DeliveryPanel: " + bRefresh);
				bMarkedDelivered.setEnabled(false);
			}
			else{
				System.err.println("Dont know what to do with JButton in OrderPanel: " + ((JButton)e.getSource()).getText());
			}
		}	
	}
	public void newDoneOrder(){
		deliveryPanel.action(DeliveryPanel.REFRESH);	
		PrintLine.println("Selected button in DeliveryPanel: " + bRefresh);
		bMarkedDelivered.setEnabled(false);
	}
}
