package no.ntnu.it1901.resturant.UI.Delivery;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import no.ntnu.it1901.resturant.Objecter.OrderOb;
import no.ntnu.it1901.resturant.Objecter.CustomerOb;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.other.PrintLine;

/**
 * This class creates a panel, with a border,
 * the panel contains deliveryMapPanel and DeliveryOrderPanel, and is their parent panel.
 * gives them their designated space on gui.
 * 
 * @author Jonas
 *
 */
public class DeliveryPanel extends JPanel implements PanelAdjustment {
	
	//parent panel
	MainGUI gui;
	
	//Sub panel
	public DeliveryOrderPanel deliveryOrderPanel;
	DeliveryMapPanel deliveryMapPanel;
	
	String sBorderTitle = "Velg ordre";
	
	//All the undelivered orders and customers 
	
	public static Object[][] unfinishedOrders = null;
	OrderOb[] orders = null;
	CustomerOb[] customers = null;

	//opcodes used
	public final static int GET_COMPLETED_ORDERS = 3100;
	public final static int PICKED_CUSTOMER = 3300;
	public final static int REFRESH = 3301;
	public final static int DELIVERED = 3302;
	
	
	/**
	 * Initiates the DeliveryPanel and its subPanels DeliveryMapPanel, DeliveryOrderPanel
	 * 
	 * @param gui
	 */
	public DeliveryPanel(MainGUI gui) {
		this.gui = gui;
				
		TitledBorder tb = BorderFactory.createTitledBorder(sBorderTitle);
		setBorder(tb);
		
		//Disable the layoutManager
		setLayout(null);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Panels
		deliveryOrderPanel = new DeliveryOrderPanel(this);
		deliveryMapPanel = new DeliveryMapPanel(this);
		
		add(deliveryOrderPanel);
		add(deliveryMapPanel);
		
		gui.notifyController(GET_COMPLETED_ORDERS, 0);
		orders = new OrderOb[unfinishedOrders.length];
		customers = new CustomerOb[unfinishedOrders.length];
		deliveryOrderPanel.orders.setListData(getCustomers());
	}
	

	/**
	 * opCode to Controller DeliveryPanel<br><br>
	 * 3000 = Get completed orders
	 * 
	 * opCode from DeliveryOrderPanel<br><br>
	 * 3300 = PICKED_CUSTOMER
	 * 3301 = REFRESH
	 * 3302 = DELIVERED
	 */
	public void action(int opCode) {
		PrintLine.println("DeliveryPanel recived opCode: " + opCode + " from " + new Throwable().fillInStackTrace().getStackTrace()[1].getFileName());
		
		switch (opCode) {
			
			case
				DeliveryPanel.PICKED_CUSTOMER:
					if (unfinishedOrders.length < 0 || unfinishedOrders == null){
						System.out.println("ingen bestillinger");
						deliveryOrderPanel.orderInfo.setText("INGEN KUNDER ATM");
					}
					else{
						int id = deliveryOrderPanel.pickedItem;
						String info = "";
						info = createInfoString(id);
						System.out.println("Pressed a customer");
						deliveryMapPanel.setLocation(createAddressString(id), createPostnummerString(id));
						deliveryOrderPanel.orderInfo.setText(info);
						repaint();
						validate();
					}
			break;
			case
				DeliveryPanel.REFRESH:
					gui.notifyController(GET_COMPLETED_ORDERS, 0);
					orders = getOrders();
					customers = getCustomers();
					deliveryOrderPanel.orders.setListData(customers);
			break;
			case
				DeliveryPanel.DELIVERED:
					int customer = deliveryOrderPanel.orders.getSelectedIndex();
					OrderOb markedOrder = (OrderOb) unfinishedOrders[customer][0];;
					markedOrder.setLevert();
					action(DeliveryPanel.REFRESH);
			break;
			default:
				PrintLine.println("DeliveryPanel don't know what to do with opCode: " + opCode);
			break;
		}
		
	}
	

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub
		
	}

	/**
	 * When JFrame resizes it sends the new size for this JPanel,
	 * this panel also sends the new size for children panels,
	 * use it manage scaling of the panel and sub panels
	 * @param width
	 * @param height
	 */
	public void resizePanel(int width, int height) {
		int vGap = 15;	//Vertical space between elements
		int borderSpace = 15;//To easy let border display
		
		int deliveryOrderPanelWidth = width/2 - borderSpace - vGap/2;
		int deliveryOrderPanelHeight= height - borderSpace*2;
		
		int deliveryMapPanelWidth = width/2 - borderSpace - vGap/2;
		int deliveryMapPanelHeight= height - borderSpace*2;
		
		deliveryOrderPanel.setBounds(borderSpace, borderSpace, deliveryOrderPanelWidth, deliveryOrderPanelHeight);
		deliveryOrderPanel.resizePanel(deliveryOrderPanelWidth, deliveryOrderPanelHeight);
		
		deliveryMapPanel.setBounds(borderSpace + vGap + deliveryOrderPanelWidth, borderSpace, deliveryMapPanelWidth, deliveryMapPanelHeight);
		deliveryMapPanel.resizePanel(deliveryMapPanelWidth, deliveryMapPanelHeight);
		
	}

	public void setCompletedOrders(OrderOb[] orders) {
		// TODO Auto-generated method stub
		
	}
	/**
	 * Extracts all the orders from the unfinishedOrders Array, which contains the orders and the customers
	 * @return OrderOb contains all the unfishedOrders
	 */
	public OrderOb[] getOrders(){
		orders = new OrderOb[unfinishedOrders.length];
		for(int i = 0; i < unfinishedOrders.length; i++){
			 orders[i] = (OrderOb) unfinishedOrders[i][0];
		}
		return orders;
	}
	
	/**
	 * Extracts all the customers from the unfinishedOrders Array, which contains the orders and the customers
	 * @return CustomerOb contains all the unfishedOrders
	 */
	public CustomerOb[] getCustomers(){
		customers = new CustomerOb[unfinishedOrders.length];
		for(int i = 0; i < unfinishedOrders.length; i++){
			customers[i] = (CustomerOb) unfinishedOrders[i][1];
		}
		return customers;
	}
	/**
	 * Creates a string thats contains all the info in the toString Methods of the OrderOb and CustmerOb classes
	 * @return a String with all the info(in a number of rows)
	 */
	public String createInfoString(){
		
		orders = new OrderOb[unfinishedOrders.length];
		customers = new CustomerOb[unfinishedOrders.length];
		for(int i = 0; i < unfinishedOrders.length; i++){
			 orders[i] = (OrderOb) unfinishedOrders[i][0];
			 customers[i] = (CustomerOb) unfinishedOrders[i][1];
		}
		String result = "";
		for(int i = 0; i < unfinishedOrders.length; i++){
			result += "Order:\n";
			result += orders[i].toString();
			result += "Customer:\n";
			result += customers[i].toString() + "\n";
		}
		
		return result;
	}
	/**
	 * Creates a string thats contains all the info in the toString Methods of the
	 * OrderOb and CustmerOb classes of one specific Order(line in the unfinishedOrdersArray
	 * @return a String with all the info
	 * @param j the place in the array of the order you want info about
	 */
	public String createInfoString(int j){
		
		orders = new OrderOb[unfinishedOrders.length];
		customers = new CustomerOb[unfinishedOrders.length];
		for(int i = 0; i < unfinishedOrders.length; i++){
			 orders[i] = (OrderOb) unfinishedOrders[i][0];
			 customers[i] = (CustomerOb) unfinishedOrders[i][1];
		}
		String result = "";
		String orderString = orders[j].toString() + "\n";
		orderString = orderString.replaceAll("--", "\n\t");
		result += "Order:\n\t";
		result += orderString;
		result += "Customer:\n\t";
		result += customers[j].toString() + "\n\tAdresse:  " + customers[j].getAdresse() + "\n";
		
		
		return result;
	}
	
	/**
	 * Creates a String with all address of one customer
	 * @param j the customer you want
	 * @return the address as a String
	 */
	public String createAddressString(int j){
		
		customers = new CustomerOb[unfinishedOrders.length];
		for(int i = 0; i < unfinishedOrders.length; i++){
			 customers[i] = (CustomerOb) unfinishedOrders[i][1];
		}
		return customers[j].getAdresse();

	}
	
	/**
	 * Creates a String with postnummer(postalcode) of one customer
	 * @param j the customer you want
	 * @return the address as a String
	 */
	public String createPostnummerString(int j){
		
		customers = new CustomerOb[unfinishedOrders.length];
		for(int i = 0; i < unfinishedOrders.length; i++){
			 customers[i] = (CustomerOb) unfinishedOrders[i][1];
		}
		return ""+ customers[j].getPostnummer();

	}
	
}
