package no.ntnu.it1901.resturant.UI;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.StyledEditorKit.BoldAction;

import no.ntnu.it1901.resturant.other.PrintLine;
/**
 * GUIMenuBar contains the JMenuBar for MainGUI class.<br>
 * <br>
 * Its only job is to display the menu and call action(opCode) in MainGUI when
 * a click has been noticed.
 * 
 * @author ghenrik
 *
 */
public class GUIMenuBar extends JMenuBar implements PanelAdjustment, ActionListener{
	
	MainGUI gui;
	JMenu settings; //blank is to make some distance (simple hack?)
	
	//Admin to add/remove order and dish, adjust price and restaurant name,
	//mysql for raw access to database
	JMenuItem registration, kitchen, delivery, admin, exit;
	
	final static Font FONT = MainGUI.FONT.deriveFont(Font.PLAIN, 12);
	
	private final String 
		sSettings = "Instillinger                ", //Extra spaces to give more "air" in JMenuBar
		sRegistration = "Registrering",
		sKitchen = "Kjkken",
		sDelivery = "Levering",
		sAdmin = "Administrering",
		sExit = "Exit";
	/**
	 * Initiates GUIMenuBar
	 * @param gui
	 */
	public GUIMenuBar(MainGUI gui) {
		this.gui = gui;
		addComponents();
	}
	/**
	 * Adds menu items to JMenuBar and its listners
	 */
	private void addComponents() {
		settings = new JMenu(sSettings);
		settings.setFont(FONT);
		
		admin = new JMenuItem(sAdmin);
		admin.addActionListener(this);
		
		

		exit = new JMenuItem(sExit);
		exit.addActionListener(this);
		
		settings.add(admin);
		settings.addSeparator();
		settings.add(exit);
		
		//used so we get the same pictures after exporting
		ClassLoader cldr = this.getClass().getClassLoader();
		
		java.net.URL imageURL   = cldr.getResource("img/iconRegistrering.gif");
		if (imageURL == null){
			imageURL   = cldr.getResource("no/ntnu/it1901/resturant/img/book.gif");
		}
		registration = new JMenuItem(sRegistration,new ImageIcon(imageURL));
		registration.setFont(FONT);
		//Alt+1 short key
		registration.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_1, ActionEvent.ALT_MASK));
		registration.addActionListener(this);
		
		imageURL   = cldr.getResource("img/iconKjkken.gif");
		if (imageURL == null){
			imageURL   = cldr.getResource("no/ntnu/it1901/resturant/img/bread.gif");
		}
		kitchen = new JMenuItem(sKitchen,new ImageIcon(imageURL));
		kitchen.setFont(FONT);
		//Alt+2 short key
		kitchen.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_2, ActionEvent.ALT_MASK));
		kitchen.addActionListener(this);
		
		imageURL   = cldr.getResource("img/iconLevering.gif");
		if (imageURL == null){
			imageURL   = cldr.getResource("no/ntnu/it1901/resturant/img/compass.gif");
		}
		delivery = new JMenuItem(sDelivery,new ImageIcon(imageURL));
		delivery.setFont(FONT);
		//Alt+3 short key
		delivery.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_3, ActionEvent.ALT_MASK));
		delivery.addActionListener(this);

		add(settings);
		add(registration);
		add(kitchen);
		add(delivery);

	}


	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub
		
	}

	
	final static int REGISTRATION 	= 100;
	final static int KITCHEN 		= 101;
	final static int DELIVERY		= 102;
	final static int ADMIN_PANEL	= 110;
	final static int EXIT 			= 112;
	final static int UPDATE			= 113;
	/**
	 * opCode from JMenuBar<br>
	 * 100 = Registration<br>
	 * 101 = Kitchen<br>
	 * 102 = Delivery<br>
	 * <br>
	 * 110 = Admin Panel<br>
	 * 112 = Exit Program<br>
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		PrintLine.println("MenuBar was pressed: " +
				(e.getSource() instanceof JMenuItem ? ((JMenuItem)e.getSource()).getText() : "Err: Not A JMenuItem"));
		
		if(e.getSource() == registration){
			gui.action(REGISTRATION);
		}
		else if(e.getSource() == kitchen){
			gui.action(KITCHEN);
		}
		else if(e.getSource() == delivery){
			gui.action(DELIVERY);
		}
		else if(e.getSource() == admin){
			gui.action(ADMIN_PANEL);
		}

		else if(e.getSource() == exit){
			gui.action(EXIT);
		}
		else{
			PrintLine.println("No action found for MenuBar: " + e.getSource());
		}
		
		
	}
	
//--Dont Need these methods
	@Override
	public void repaintPanel() {}
	@Override
	public void requestRefresh() {}
	@Override
	public void resizePanel(int width, int height) {}


}
