package no.ntnu.it1901.resturant.UI;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import no.ntnu.it1901.resturant.Objecter.OrderOb;
import no.ntnu.it1901.resturant.Objecter.CustomerOb;
import no.ntnu.it1901.resturant.Objecter.DishOb;
import no.ntnu.it1901.resturant.UI.Chef.ChefPanel;
import no.ntnu.it1901.resturant.UI.Delivery.DeliveryPanel;
import no.ntnu.it1901.resturant.UI.Order.OrderPanel;
import no.ntnu.it1901.resturant.UI.Settings.AdminSettingPanel;
import no.ntnu.it1901.resturant.controller.Controller;
import no.ntnu.it1901.resturant.other.PrintLine;


/**
 * This class initiates the main JFrame and all its subJPanels to display the GUI for
 * the restaurant. Given is a Tree structure off all sub panels<br>
 * 

<!--The Following segment is HTML Formatted-->

JFrame MainGUI<br>
|<br>
|-OrderPanel<br>
|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|-CustomerChooserPanel<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|-ManualInputPanel<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|-SearchCustomerPanel<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|-ResultCustomerPanel<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|-PickedCustomerPanel<br>
|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|-SearchCustomer<br>
|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|-DishChooserPanel<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|-SearchDishPanel<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|-ListDishPanel<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|-CommentDishPanel<br>
|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|-ReceiptPanel<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|-ReceiptResultsPanel<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|&nbsp&nbsp&nbsp&nbsp|-ReceiptSettingsPanel<br>
|<br>
|-DeliveryPanel<br>
|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|-DeliveryMapPanel<br>
|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|-DeliveryOrderPanel<br>
|<br>
|-ChefPanel<br>
|<br>
|-AdminSettingPanel<br>
|&nbsp&nbsp&nbsp&nbsp|<br>
|&nbsp&nbsp&nbsp&nbsp|-NewDishPanel<br>


 * @author ghenrik
 *
 */
public class MainGUI extends JFrame implements PanelAdjustment,ActionListener, ComponentListener{

	//Variable initializing
	private Controller controller;		//to call the method notifyUpdate()	
	private DishOb[] menu;				//Menu list of servings
	private CustomerOb[] customers;			//List of all customers
	private CustomerOb customerInFocus; 		//Current picked customer
	
	//Settings
	private float deliveryPrice = 60; //Default delivery Price
	private float deliveryFree = 500;	//Default Free delivery if total order above this value

	private int[] frameSize = {1200, 800};
	private String restaurantName = "Resturant Company";
	
	//Font
	public final static String fontType = "Tahoma";
	public final static Font FONT = new Font(fontType, Font.BOLD, 12);
	
	//Special settings
	public final static boolean viewPanelShapes = false; //If we want to see the panels positions
	
	//Panels
	OrderPanel orderPanel;
	public DeliveryPanel deliveryPanel;
	public ChefPanel chefPanel;
	AdminSettingPanel adminSettingPanel;
	
	//Currentpanel contains the panel currently displayed
	JPanel currentPanel;
	
	//MenuBar
	GUIMenuBar mainMenuBar;




	/**
	 * This initializes the JFrame with menu and all sub panels, including GUIMenuBar<br>
	 * <br>
	 * It reads properties from config.txt file:<br>
	 * eksample:<br>
	 * -------<br>
	 * #Name of resturant<br>
	 * NAME=Carlos Chef<br>
	 * <br>
	 * #How much it costs to deliver food<br>
	 * DELIVERY_PRICE=59.90<br>
	 * <br>
	 * #Delivery is free if total price is over this limit<br> 
	 * DELIVERY_FREE=300<br>
	 * ------<br>
	 * It sets the size of window and displays it in the middle of the screen<br>
	 * <br>
	 * Its Parameters includes: <br>
	 * controller: The controller that MainGUI calls the method notifyChange(opCode)<br>
	 * menu[]: Array of dishes<br>
	 * customers[]: Array of customers<br>
	 * orders[]: Array of uncomleted orders
	 * 
	 * @param controller
	 * @param menu
	 * @param customers
     * @param orders
	 */
	public MainGUI(Controller controller, DishOb[] menu, CustomerOb[] customers, OrderOb[] orders){
		
		this.controller = controller;
		this.menu = menu;
		this.customers = customers;
		
		//Read properties and fill them in
		//ETC, name of restaurant, freeDelivery
		readProperties();
		
		//Title of program
		setTitle(getRestaurantName());

		//Creat menuBar
		mainMenuBar = new GUIMenuBar(this);
		setJMenuBar(mainMenuBar);
		
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setSize(frameSize[0],frameSize[1]);
		
		//Center the window in middle of screen
		setLocationRelativeTo(null);
		
		//Disables layoutmananger
		setLayout(null);
		
		//Add Frame resize lister and setVisible=true to get values
		setVisible(true);
		addComponentListener(this);
		
		//Initialize Panels
		deliveryPanel = new DeliveryPanel(this);
		chefPanel = new ChefPanel(this);
		adminSettingPanel = new AdminSettingPanel(this);
		orderPanel = new OrderPanel(this, customers);
		
		//StartPanel
		currentPanel = orderPanel;//orderPanel;
		
		//Add Panels
		add(currentPanel);
		
		//Redraw what we got
		repaintPanel();
				
	}
	/**
	 * Notify controller that we want to accsess or change something in database
	 * @param opCode
	 * @param id
	 */
	public void notifyController(int opCode, int id){
		controller.notifyChange(opCode, id);
	}
	
	/**
	 * On new customer added to database, retreve it to insert it to list
	 */
	public void setSingleCustomer(CustomerOb customer){
		orderPanel.setSingleCustomer(customer);
	}
	
	/**
	 * Remove old panel and insert the new one.
	 * It then calls repaintPanel();
	 * @param panel
	 */
	private void changePanelTo(JPanel panel){
		remove(currentPanel);
		currentPanel = panel;
		add(currentPanel);
		repaintPanel();
	}

	public void warningMessage(String message){
		JOptionPane.showMessageDialog(null,message);
	}
	/**
	 * Reads in properties from config.txt file in the same
	 * folder as MainGUI.class
	 */
	private void readProperties(){
		Properties configFile = new Properties();
		File file = new File("config.txt");
		
		if(file.exists()){
			try {
				configFile.load(new FileReader(file));
				PrintLine.println("Reading Properties:");
				
				String rName = configFile.getProperty("NAME");
				String dPrice = configFile.getProperty("DELIVERY_PRICE");
				String dFree = configFile.getProperty("DELIVERY_FREE");
				String tempPort = configFile.getProperty("PORT");
				String tempDatabase = configFile.getProperty("DATABASE");
				
				if(rName != null && rName.length() > 0){
					restaurantName = rName;
					PrintLine.println("\tName of resturant: " + getRestaurantName());
				}else{
					PrintLine.println("\tCould not find NAME and its key in config.txt, defaults to: " + getRestaurantName());
				}

				if(dPrice != null && dPrice.length() > 0){
					try {
						float price = Float.parseFloat(dPrice);
						deliveryPrice = price;
						PrintLine.println("\tDeliveryCost: " + deliveryPrice);
					} catch (NumberFormatException e) {
						PrintLine.println("\tFailed to parse String to float, defaults deliveryPrice to: " + deliveryPrice);
						e.printStackTrace();
					}
				}else{
					PrintLine.println("\tCould not find DELIVERY_PRICE and its key in config.txt, defaults to: " + deliveryPrice);
				}
				if(dFree != null && dFree.length() > 0){
					try {
						float free = Float.parseFloat(dFree);
						deliveryFree = free;
						PrintLine.println("\tFree delivery from: " + deliveryFree);
					} catch (NumberFormatException e) {
						PrintLine.println("\tFailed to parse String to float, defaults deliveryFree to: " + deliveryFree);
						e.printStackTrace();
					}
				}else{
					PrintLine.println("\tCould not find DELIVERY_FREE and its key in config.txt, defaults to: " + deliveryFree);
				}

			} catch (FileNotFoundException e) {
				System.out.println("Could not find file for config. (Parden? I just took file.exist to enter if statement?)");
				e.printStackTrace();
			} catch (IOException e) {
				System.out.println("Failed to read file. Its there, its just borked.");
				e.printStackTrace();
			}			
		}
		else{
			PrintLine.println("Could not find config.txt file. Default values taken instead. (Could the move from GUI2 to GUI package be the problem?)");
		}
	}

	
//--Get and Set methods
	/**
	 * Used by ListDishPanel to fetch the menu
	 */
	public DishOb[] getMenu() {
		return menu;
	}
	
	/**
	 * To be used by DeliveryPanel<br>
	 * Gives the list of completed (but not delivered) orders to DeliveryPanel<br>
	 * <br>Method not properly implemented yet
	 * @param orders
	 */
	public void setCompletedOrders(OrderOb[] orders){
		deliveryPanel.setCompletedOrders(orders);
	}
	/**
	 * Returns resturantName, to be used in receipt
	 * @return restaurantName
	 */
	public String getRestaurantName() {
		return restaurantName;
	}
	/**
	 * Returns deliveryPrice, to be used in receipt
	 * @return deliveryPrice
	 */
	public float getDeliveryPrice() {
		return deliveryPrice;
	}
	/**
	 * Returns free delivery cost, to be used in receipt
	 * @return delvieryFree
	 */
	public float getDeliveryFree() {
		return deliveryFree;
	}
	/**
	 * Get new customer from input panel in order panel
	 */
	public CustomerOb getNewCustomer(){

		return orderPanel.getNewCustomer();
	}
	/**
	 * Builds and return the complete order from Orderpanel
	 */
	public OrderOb getNewOrder(){
		return orderPanel.getNewOrder();
	}
	/**
	 * Return picked Customer with edited changes.
	 * @return getPickedCustomer()
	 */
	public CustomerOb getPickedCustomer(){
		return orderPanel.getPickedCustomer();
	}
	
	/**
	 * Edits a customer based on customerID
	 */
	public void editCustomer(CustomerOb customer){
		orderPanel.editCustomer(customer);
	}
	/**
	 * When order is completed, reset orderpanel
	 */
	public void resetOrder(){
		orderPanel.resetOrder();
		
	}
	
	/**
	 * Returns an DishOb with the new dish to be included in database.
	 */
	public DishOb getNewDish(){
		return adminSettingPanel.getNewDish();
	}
	/**
	 * Adds a new dish to dishList, happens when we want to add a new dish from admin panel
	 * @param dishOb
	 */
	public void addNewDish(DishOb dishOb) {
		DishOb[] menulist = new DishOb[menu.length+1];
		for (int i = 0; i < menu.length; i++) {
			menulist[i] = menu[i];
		}
		menulist[menulist.length-1] = dishOb;
		
		menu = menulist;
		orderPanel.requestRefresh();
	}
	
//--End Get and Set methods
	
	
//--Interface Methods
	
	@Override
	public void repaintPanel() {
		repaint();
		validate();
		
	}


	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void resizePanel(int width, int height) {
		orderPanel.setBounds(0, 0, width, height);
		orderPanel.resizePanel(width, height);
		deliveryPanel.setBounds(0, 0, width, height);
		deliveryPanel.resizePanel(width, height);
		chefPanel.setBounds(0, 0, width, height);
		chefPanel.resizePanel(width, height);
		adminSettingPanel.setBounds(0, 0, width, height);
		adminSettingPanel.resizePanel(width, height);
		
	}
	
	/**
	 * opCode from JMenuBar<br><br>
	 * 100 = Registration<br>
	 * 101 = Chef<br>
	 * 102 = Delivery<br>
	 * <br>
	 * 110 = Admin Panel<br>
	 * 111 = Mysql access<br>
	 * 112 = Exit Program<br>
	 * 114 = Update from database
	 * 
	 * opCode from DeliveryPanel<br><br>
	 * 3000 = Get completed orders
	 */
	@Override
	public void action(int opCode) {
		
		PrintLine.println("MainGUI recived action opCode: " + opCode);
		
		switch (opCode) {
		case GUIMenuBar.REGISTRATION:
			changePanelTo(orderPanel);
			break;
			
		case GUIMenuBar.KITCHEN:
			changePanelTo(chefPanel);
			break;
			
		case GUIMenuBar.DELIVERY:
			changePanelTo(deliveryPanel);
			
			break;
	
		case GUIMenuBar.UPDATE:
			
			break;
			
		case GUIMenuBar.ADMIN_PANEL:
			changePanelTo(adminSettingPanel);
			break;
			
		case DeliveryPanel.GET_COMPLETED_ORDERS:
			controller.notifyChange(opCode, -1);
			break;
			
		case GUIMenuBar.EXIT:
			System.out.println("Exit Program");
			System.exit(0);
			break;
			
		
			
		default:
			PrintLine.println("MainGUI don't know what to do with opCode: " + opCode);
			break;
		}
	}	
	
	final static int GET_COMPLETEDE_ORDERS = 50;
	public static java.sql.Connection con = null;
	
	
	@Override
	public void actionPerformed(ActionEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void componentResized(ComponentEvent arg0) {
		int width = this.getContentPane().getSize().width;
		int height =  this.getContentPane().getSize().height;
		PrintLine.println("Frame Resized: x=" + width + ", y=" + height);
		resizePanel(width, height);
		repaintPanel();
		
	}

	//No need for these listeners
	@Override
	public void componentHidden(ComponentEvent arg0) {}
	@Override
	public void componentMoved(ComponentEvent arg0) {}
	@Override
	public void componentShown(ComponentEvent arg0) {}
	
	
//--Test methods, to be used when there is no controller
	
	/**
	 * To test the program on its own
	 * @param args
	 */
	/*public static void main(String[] args) {
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				try {
					UIManager.setLookAndFeel( UIManager.getSystemLookAndFeelClassName());  //Change theme to OS one
			    } 
			    catch (UnsupportedLookAndFeelException e) {}
			    catch (ClassNotFoundException e) {}
			    catch (InstantiationException e) {}
			    catch (IllegalAccessException e) {}
			    //CreateConnection();
				new MainGUI(new Controller(), getFakeMenu(), getFakeCustomers(), null);
			}

		});
	}
	public static void CreateConnection() {
		// TODO Auto-generated method stub
		try {
			// pner forbinnelse mellom databasen og programmet
			Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
			con = DriverManager.getConnection("jdbc:derby://localhost:1527/it1901");
		}catch (SQLException e) {
			System.err.println("database error");
		}
		catch (Exception e) {
			System.err.println("Conection til databasen ikke opprettet!!");
		}
	}
		
	
	/**
	 * Generate Fake Customers to test the program with
	 */	/*
	private static CustomerOb[] getFakeCustomers() {
		CustomerOb[] results = new CustomerOb[10];
		for (int i = 0; i < results.length; i++) {
			results[i] = new CustomerOb("Fornavn" + i, "Etternavn" +i, "Addresse" + i, i +"987654321", "Poststed" + i,1111*i, -(i+1));
		}
		return results;

	}

	/**
	 * Generate Fake Menu to test the program with
	 */	/*
	private static DishOb[] getFakeMenu() {
		DishOb[] results = new DishOb[10];
		for (int i = 0; i < results.length; i++) {
			results[i] = new DishOb(11*i, i + "MatrettDelikatesse", "Dette er en test kommentar for matrett nr. " + i + ". Hper det smaker. Smaker Smaker Smaker Smaker Smaker Smaker Smaker Smaker", -(i+1));
		}
		return results;
	}*/




}
