package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;

import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;

/**
 * The CommentDishPanel is a subPanel of DishChooserPanel<br>
 * <br>
 * It's job is to display a dish comment. (Etc, that a dish is hot and contain nuts) 
 * and to add an overall comment on an order (Etc, no pickles on one burger).<br>
 * <br>
 * Including that, it contains the final Confirm order button that calls OrderPanel to collect
 * all information in its subpanels.
 * @author ghenrik
 *
 */
public class CommentDishPanel extends JPanel implements PanelAdjustment, ActionListener{
	
	//Parent Panel
	DishChooserPanel dishChooserPanel;
	
	//Comments
	JTextPane dishComment, orderComment;
	JScrollPane scrollDishComment, scrollOrderComment;
	
	//Finish Order Button
	JButton bCompleteOrder, bReset;
	private String 
		sCompleteOrder 	= "<html>Fullfr<br>ordre<br>",
		sReset 			= "Reset";
	
	/**
	 * Initiates the Comment dish panel, sets it's parent panel,
	 * sets layout to null, make the panel background opaque and
	 * adds it comments area and complete order button
	 * @param dishChooserPanel
	 */
	public CommentDishPanel(DishChooserPanel dishChooserPanel) {
		this.dishChooserPanel = dishChooserPanel;
		

		setBackground(Color.ORANGE);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Disable layout
		setLayout(null);
		
		addComponents();
		
	}
	/**
	 * Simply initiates the components, the fonts, it's listeners and add them to panel
	 */
	private void addComponents() {
		dishComment = new JTextPane();
		orderComment = new JTextPane();
		
		scrollDishComment = new JScrollPane(dishComment);
		scrollOrderComment = new JScrollPane(orderComment);
		
		bCompleteOrder = new JButton(sCompleteOrder);
		bCompleteOrder.addActionListener(this);
		bCompleteOrder.setFont(MainGUI.FONT);
		
		bReset = new JButton(sReset);
		bReset.addActionListener(this);
		bReset.setFont(MainGUI.FONT);
		
		dishComment.setEditable(false);
		dishComment.setFont(MainGUI.FONT);	
		dishComment.setBackground(new Color(0xBBBBBB));
		
		add(scrollDishComment);
		add(scrollOrderComment);
		add(bCompleteOrder);
		add(bReset);
	}
	/**
	 * When order is completed, reset comment
	 */
	public void resetComment() {
		orderComment.setText("");
		
	}
	
	//--Get and Set methods
	/**
	 * When a menu name is clicked in ListDishPanel, this method gets called
	 * to update the dishComment section
	 */
	public void setDishCommentText(String text) {
		dishComment.setText(text);
		
	}
	
	//--End Get and Set methods

	//--Implemented Methods
	
	/**
	 * OP code for CommentDishPanel<br>
	 * COMPLETE_ORDER = 1700;
	 */
	public final static int COMPLETE_ORDER = 1700;
	public final static int RESET_DISH_LIST = 1701;
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == bCompleteOrder){
			dishChooserPanel.action(COMPLETE_ORDER);
		}
		else if(e.getSource() == bReset){
			dishChooserPanel.action(RESET_DISH_LIST);
		}
		
		
	}
	//Not necessary to use some of them
	@Override
	public void action(int opCode) {}
	@Override
	public void repaintPanel() {}
	@Override
	public void requestRefresh() {}
	@Override
	public void resizePanel(int width, int height) {
		int completeOrderWidth = 100;
		int resetButtonSize = 30;
		int dishCommentWidth = (width-completeOrderWidth)/2;
		int orderCommentWidth = dishCommentWidth;
		
		scrollDishComment.setBounds(0, 0, dishCommentWidth, height);
		scrollOrderComment.setBounds(dishCommentWidth, 0, orderCommentWidth, height);
		bCompleteOrder.setBounds(dishCommentWidth + orderCommentWidth, resetButtonSize, completeOrderWidth, height-resetButtonSize);
		bReset.setBounds(dishCommentWidth + orderCommentWidth, 0,completeOrderWidth, resetButtonSize);
	}



}
