package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import no.ntnu.it1901.resturant.Objecter.CustomerOb;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.other.PrintLine;

/**
 * The CustomerChooserPanel is a subPanel of OrderPanel<br>
 * <br>
 * Its job is to contain and control all panels that is necessary for searching,
 * selecting, adding and editing customers.<br>
 * <br>
 * Contains the sub panels ManualInputPanel, SearchCustomerPanel,
 * ResultCustomerPanel and PickedCustomerPanel<br>
 * 
 * @author ghenrik
 *
 */
public class CustomerChooserPanel extends JPanel implements PanelAdjustment {
	
	//Parent Panel
	OrderPanel orderPanel;
	
	//Sub Panels
	ManualInputPanel manualInputPanel;
	SearchCustomerPanel searchCustomerPanel;
	ResultsCustomerPanel resultCustomerPanel;
	PickedCustomerPanel pickedCustomerPanel;
	
	String sBorderTitle = "Velg Kunde";
	
	
	/**
	 * Initiates the CustomerChooserPanel and its subPanels ManualInputPanel, 
	 * SearchCustomerPanel, ResultCustomerPanel and PickedCustomerPanel.
	 * @param orderPanel
	 */
	
	public CustomerChooserPanel(OrderPanel orderPanel) {
		this.orderPanel = orderPanel;
		
		this.setBackground(Color.BLUE);
		
		TitledBorder tb = BorderFactory.createTitledBorder(sBorderTitle);
		setBorder(tb);
		
		//Disable the layoutManager
		setLayout(null);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Panels
		manualInputPanel = new ManualInputPanel(this);
		searchCustomerPanel = new SearchCustomerPanel(this);
		resultCustomerPanel = new ResultsCustomerPanel(this);
		pickedCustomerPanel = new PickedCustomerPanel(this);
		
		add(manualInputPanel);
		add(searchCustomerPanel);
		add(resultCustomerPanel);
		add(pickedCustomerPanel);
		
		//Display list with all customers on startup.
		searchManual();
	}
	
	/**
	 * If ManualInputPanel is changed this method is called to find matches in SearchCustomer
	 * and put them in ResultsCustomerPanel
	 */
	public void searchManual(){
		resultCustomerPanel.setResults(
				orderPanel.searchCustomer.searchCustomer(
						manualInputPanel.getForename(),
						manualInputPanel.getSurname(),
						manualInputPanel.getAddress(),
						manualInputPanel.getTelephone(),
						manualInputPanel.getTown(),
						manualInputPanel.getPostCode()));
		PrintLine.println("End search for customer");
	}
	/**
	 * If SearchCustomerPanel is changed this method is called to find matches in SearchCustomer
	 * and put them in ResultsCustomerPanel
	 */
	public void searchGeneral() {
		resultCustomerPanel.setResults(
				orderPanel.searchCustomer.searchCustomer(
						searchCustomerPanel.getSearchBar()));
		
	}

	/**
	 * When order is completed, reset orderpanel
	 */
	public void resetOrder(){
		manualInputPanel.resetTextFields();
	}
	
	/**
	 * Returns a string of picked Customer to be used in receipt
	 * 
	 * @return getReciptCustomer()
	 */
	public String buildReceiptName() {
		return pickedCustomerPanel.getReciptCustomer();
		
	}
//--Get and Set methods
	/**
	 * Get new customer from input panel
	 * 
	 * @return getNewCustomer()
	 */
	public CustomerOb getNewCustomer(){
		return manualInputPanel.getNewCustomer();
	}
	/**
	 * Returns picked customer, includes database id and changes made to customer
	 * 
	 * @return getPickedCustomer()
	 */
	public CustomerOb getPickedCustomer(){
		return pickedCustomerPanel.getPickedCustomer();
	}

//--End Get and Set methods
	
//--Implemented methods
	
	/**
	 * opCode from ManualInputPanel<br><br>
	 * NEW_CUSTOMER 		= 1100;<br>
	 * FORENAME_CHANGED 	= 1101;<br>
	 * SURNAME_CHANGED  	= 1102;<br>
	 * TELEPHONE_CHANGED 	= 1103;<br>
	 * ADDRESS_CHANGED  	= 1104;<br>
	 * POSTCODE_CHANGED 	= 1105;<br>
	 * TOWN_CHANGED  		= 1106;<br>
	 * <br><br>
	 * 
	 * opCode from SearchCustomerPanel<br><br>
	 * GENERAL_SEARCH 		= 1200;<br>
	 * 
	 * opCode from ResultsCustomerPanel<br><br>
	 * PICKED_CUSTOMER 		= 1300;<br>
	 * 
	 * opCode from PickedCustomerPanel<br><br>
	 * EDIT_CUSTOMER 		= 1400;<br>
	 */

	@Override
	public void action(int opCode) {
		//Yeah, that fun line gives us the name of the class who called this action method! Brilliant!
		PrintLine.println("CustomerChooserPanel recived opCode: " + opCode + " from " + new Throwable().fillInStackTrace().getStackTrace()[1].getFileName());
		
		switch (opCode) {
		
		//ManualInputPanel
		case ManualInputPanel.NEW_CUSTOMER:
			orderPanel.gui.notifyController(ManualInputPanel.NEW_CUSTOMER, -1);
			break;
			
		case ManualInputPanel.FORENAME_CHANGED:
			searchManual();
			break;
		
		case ManualInputPanel.SURNAME_CHANGED:
			searchManual();
			break;
			
		case ManualInputPanel.TELEPHONE_CHANGED:
			searchManual();
			break;
			
		case ManualInputPanel.ADDRESS_CHANGED:
			searchManual();
			break;
			
		case ManualInputPanel.POSTCODE_CHANGED:
			searchManual();
			break;
			
		case ManualInputPanel.TOWN_CHANGED:
			searchManual();
			break;
		//SearchCustomerPanel
		case SearchCustomerPanel.GENERAL_SEARCH:
			searchGeneral();
			break;	
		//ResultsCustomerPanel
		case ResultsCustomerPanel.PICKED_CUSTOMER:
			
			pickedCustomerPanel.setCustomer(resultCustomerPanel.getKunde());
			
			break;	
			
			//PickedCustomerPanel
		case PickedCustomerPanel.EDIT_CUSTOMER:
			orderPanel.gui.notifyController(PickedCustomerPanel.EDIT_CUSTOMER, -1);
			break;	
			
		default:
			PrintLine.println("CustomerChooserPanel don't know what to do with opCode: " + opCode);
			break;
		}
		
		
	}



	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void resizePanel(int width, int height) {
		
		int vGap = 15;	//Vertical space between elements
		int borderSpace = 10;//To easy let border display
		
		int manualInputPanelWidth = 200;
		int manualInputPanelHeight = height - borderSpace*2;
		
		int pickedCustomerPanelWidth = 160;
		int pickedCustomerPanelHeight = height - borderSpace*2;
		
		int searchCustomerPanelWidth = width - manualInputPanelWidth - pickedCustomerPanelWidth - vGap*2 - borderSpace*2;
		int searchCustomerPanelHeight= 50;
		
		int resultsCustomerPanelWidth = searchCustomerPanelWidth;
		int resultsCustomerPanelHeight= height - searchCustomerPanelHeight-borderSpace*2;
		
		manualInputPanel.setBounds(borderSpace, borderSpace, manualInputPanelWidth, manualInputPanelHeight);
		manualInputPanel.resizePanel(manualInputPanelWidth, manualInputPanelHeight);
		
		searchCustomerPanel.setBounds(manualInputPanelWidth + vGap + borderSpace, borderSpace, searchCustomerPanelWidth, searchCustomerPanelHeight);
		searchCustomerPanel.resizePanel(searchCustomerPanelWidth, searchCustomerPanelHeight);
		
		resultCustomerPanel.setBounds(manualInputPanelWidth + vGap + + borderSpace, searchCustomerPanelHeight+borderSpace, resultsCustomerPanelWidth, resultsCustomerPanelHeight);
		resultCustomerPanel.resizePanel(resultsCustomerPanelWidth, resultsCustomerPanelHeight);
		
		pickedCustomerPanel.setBounds(manualInputPanelWidth + searchCustomerPanelWidth + vGap*2 + borderSpace, borderSpace, pickedCustomerPanelWidth, pickedCustomerPanelHeight);
		pickedCustomerPanel.resizePanel(pickedCustomerPanelWidth, pickedCustomerPanelHeight);
		
	}



}
