package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;
import java.util.LinkedList;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.other.PrintLine;

/**
 * The DishChooserPanel is a subPanel of OrderPanel<br>
 * <br>
 * Its job is to contain and control all panels that is necessary for searching
 * and selecting how many you want of each dish in the menu. It also contains 
 * comments and the complete order button.
 * Contains the sub panels SearchDishPanel, ListDishPanel, CommentDishPanel<br>
 * 
 * @author ghenrik
 *
 */
public class DishChooserPanel extends JPanel implements PanelAdjustment {
	
	//Parent Panel
	OrderPanel orderPanel;
	
	//Sub Panels
	SearchDishPanel searchDishPanel;
	ListDishPanel listDishPanel;
	CommentDishPanel commentDishPanel;

	String sBorderTitle = "Velg Matrett";
	
	int width = 0;
	int height = 0;
	
	/**
	 * Initiates dishChooserPanel and its subPanels SearchDishPanel, ListDishPanela and CommentDishPanel
	 */
	public DishChooserPanel(OrderPanel orderPanel){
		this.orderPanel = orderPanel;
		
		this.setBackground(Color.BLUE);
		
		TitledBorder tb = BorderFactory.createTitledBorder(sBorderTitle);
		setBorder(tb);
		
		//Disable the layoutManager
		setLayout(null);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		
		searchDishPanel = new SearchDishPanel(this);
		listDishPanel = new ListDishPanel(this);
		commentDishPanel = new CommentDishPanel(this);
		
		add(searchDishPanel);
		add(listDishPanel);
		add(commentDishPanel);
		
	}
	/**
	 * Toss the old list dish and rebuild it<br>
	 * Is called when we have added a new dish.
	 * 
	 */
	public void recreateListDishPanel(){
		remove(listDishPanel);
		listDishPanel = new ListDishPanel(this);

		add(listDishPanel);
		
		this.resizePanel(this.width, this.height);

	}
	
	/**
	 * When order is completed, reset orderpanel
	 */
	public void resetOrder(){
		listDishPanel.resetDish();
		commentDishPanel.resetComment();
		searchDishPanel.resetSearch();
	}

	//--Get and Set methods
	
	/**
	 * ListDishPanel require this method to access the menu array at
	 * top level from MainGUI
	 */
	public OrderPanel getOrderPanel() {
		return orderPanel;
	}
	
	/**
	 * SearchDishPanel calls this method to get ListDishElements
	 * to enable/disable elements
	 * @return ListDishElement[]
	 */
	public ListDishElement[] getListDishElements() {
		return listDishPanel.getListDishElements();
	}
	
	/**
	 * Returns a string of selected menuItems;
	 */
	public String buildReceiptPrice(){
		return listDishPanel.buildReceiptPrice();
	}
	/**
	 * Return total price of all items without MVA
	 * @return total price without MVA
	 */
	public double totalPriceWithoutMVA(){
		return listDishPanel.totalPriceWithoutMVA();
	}
	/**
	 * Return an int[] of dishes selected, if a customer want multiple dishes
	 * then it is added multiple times to the int array.
	 * @return result
	 */
	public int[] getOrdersDishes() {
		LinkedList<Integer> dishResult = new LinkedList<Integer>();
		ListDishElement[] list = getListDishElements();
		for (int i = 0; i < list.length; i++) {
			for(int j = 0; j < list[i].numberOfDishes; j++){
				dishResult.add(list[i].dish.getRettId());
			}
		}
		
		PrintLine.println("Created an int[] orderDishList of " + dishResult.size() + " elements");
		
		int[] result = new int[dishResult.size()];
		int i = 0;
		for(int a: dishResult){
			result[i] = a;
			i++;
		}
		
		return result;
	}
	/**
	 * Returns comment for order, etc No pickles on one burger
	 */
	public String getCommentOrder(){
		return commentDishPanel.orderComment.getText();
	}
	//--End Get and Set methods
	
	/**
	 * OP code for CommentDishPanel<br>
	 * <br>
	 * From ListDishPanel: <br>
	 * DISH_COMMENT = 1600;<br>
	 * <br>
	 * From CommentDishPanel<br>
	 * COMPLETE_ORDER = 1700;
	 * RESET_DISH_LIST = 1701;
	 */
	
	@Override
	public void action(int opCode) {
		//Yeah, that fun line gives us the name of the class who called this action method! Brilliant!
		PrintLine.println("DishChooserPanel recived opCode: " + opCode + " from " + new Throwable().fillInStackTrace().getStackTrace()[1].getFileName());
		
		switch (opCode) {
		
		//ManualInputPanel
		case ListDishPanel.DISH_COMMENT:
			commentDishPanel.setDishCommentText(listDishPanel.getDishComment());
			break;
			
		case CommentDishPanel.COMPLETE_ORDER:
			orderPanel.gui.notifyController(CommentDishPanel.COMPLETE_ORDER, -1);
			break;
			
		case CommentDishPanel.RESET_DISH_LIST:
			listDishPanel.resetDish();
			break;	
			
		default:
			PrintLine.println("DishChooserPanel don't know what to do with opCode: " + opCode);
			break;
		}
		
		

	}

	@Override
	public void repaintPanel() {
		listDishPanel.repaintPanel();

	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub

	}

	@Override
	public void resizePanel(int width, int height) {
		
		this.height = height;
		this.width = width;
		
		int border = 10; //Border around window
		
		int searchDishPanelWidth = width - border*2;
		int searchDishPanelHeight = 50;
		
		int commentDishPanelWidth = searchDishPanelWidth;
		int commentDishPanelHeight = 100;

		int listDishPanelWidth = searchDishPanelWidth;
		int listDishPanelHeight = height-border*2-searchDishPanelHeight-commentDishPanelHeight;
		
		searchDishPanel.setBounds(border, border, searchDishPanelWidth, searchDishPanelHeight);
		searchDishPanel.resizePanel(searchDishPanelWidth, searchDishPanelHeight);

		listDishPanel.setBounds(border, border+searchDishPanelHeight, listDishPanelWidth, listDishPanelHeight);
		listDishPanel.resizePanel(listDishPanelWidth, listDishPanelHeight);
	
		commentDishPanel.setBounds(border, border+searchDishPanelHeight+listDishPanelHeight, commentDishPanelWidth, commentDishPanelHeight);
		commentDishPanel.resizePanel(commentDishPanelWidth, commentDishPanelHeight);

	}




}
