package no.ntnu.it1901.resturant.UI.Order;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

import no.ntnu.it1901.resturant.Objecter.DishOb;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.database.Dish;

/**
 * Special class used to contain buttons for a dish to be used in ListDishPanel<br>
 * <br>
 * As an array it contains the entire menu for the restaurant. The boolean datatype 
 * "display" indicates if the dish is visible. (Turned off and on by SearchDishPanel to
 * display correct results from a search)
 * 
 * Is used to contain the elements for a menu list to be displayed in GUI.
 * @author ghenrik
 *
 */

class ListDishElement{
	boolean display = true;//Indicates if this is going to be displayed
	DishOb dish;
	int numberOfDishes = 0;
	
	JButton pluss = new JButton("+");
	JButton minus = new JButton("-");
	JButton dishName;
	JTextField numberOfDishesField;
	JLabel endInfo;
	
	/**
	 * Initiates an instance of ListDishElements.<br>
	 * From the given dish it gets the name, its price, sets the font, creates 
	 * the JButton for dishname, pluss, minus, creates the JTextField for number of 
	 * dishes (default 0), and the end JLabel with price and info.
	 * 
	 * @param dish
	 */
	public ListDishElement(DishOb dish) {
		this.dish = dish;
		dishName = new JButton(dish.getRettnavn());
		dishName.setFont(MainGUI.FONT);
		
		numberOfDishesField = new JTextField(""+numberOfDishes );
		numberOfDishesField.setFont(MainGUI.FONT);
		endInfo = new JLabel();
		endInfo.setFont(MainGUI.FONT);
		updateText();
	}
	/**
	 *  Updates the JLabel with info on costs.
	 */
	private void updateText(){
		endInfo.setText(" stk. " + dish.getPris()*numberOfDishes + " kr.-  " + dish.getPris() + " kr.-");
	}
	/**
	 * Returns the dishId. (Used when completing the order)
	 * @return
	 */
	public int getId(){
		return dish.getRettId();
	}
	/**
	 * Returns JButton for pluss button.
	 * @return
	 */
	public JButton getPluss() {
		return pluss;
	}
	/**
	 * Returns JButton for minus button.
	 * @return
	 */
	public JButton getMinus() {
		return minus;
	}
	/**
	 * Manually sets the number of wanted dishes in order.<br>
	 * (Can be a negative number)
	 * @param number
	 */
	public void setNumberOfDishes(int number){
		numberOfDishes = number;
		updateText();
	}
	/**
	 * Increase number of dishes by one.
	 */
	public void increase(){
		numberOfDishes++;
		numberOfDishesField.setText(""+numberOfDishes );
		updateText();
	}
	/**
	 * Decrease number of dishes by 1.<br>
	 * Will not go below zero.
	 */
	public void decrease(){
		if(numberOfDishes > 0){
			numberOfDishes--;
			updateText();
		}
		numberOfDishesField.setText(""+numberOfDishes );
	}
}