/**
 * 
 */
package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

import no.ntnu.it1901.resturant.Objecter.DishOb;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.other.PrintLine;


/**
 * The ListDishPanel is a subPanel of DishChooserPanel<br>
 * <br>
 * It's job is to display the menu list with all its buttons, it is contained
 * within a JScrollPane that allows for a large list. It utilizes ListDishElement
 * to add the necessary components (JButton, JTextField, JLabel).<br>
 * It updates its ListDishElement[] with number of wanted dishes<br>
 * It updates list with results from SearchDishPanel and hides unmatched search results<br>
 * It still remembers the number of items when you hide them.<br>
 * <br>
 * @author ghenrik
 *
 */
public class ListDishPanel extends JPanel implements PanelAdjustment, ActionListener, DocumentListener {
	
	
	DishChooserPanel dishChooserPanel;
	JScrollPane scroll;
	JPanel dishPanel;
	ListDishElement[] listDishElements;
	int lastClickedItem = 0;
	
	//Remembers the last size of panel. (required when we search and refresh items)
	int width = 0, height = 0; 
	
	/**
	 * Initiates the ListDishPanel, sets it's parent panel,
	 * sets layout to null and make the panel background opaque.<br>
	 * <br>
	 * It then calls addComponents()<br>
	 * addComponents() creates a new JPanel to put inside a JScrollPane.<br>
	 * It creates a ListDishElement[] array from menu in MainGUI.<br>
	 * The new JPanel adds all elements from listDishElement[] and its listeners<br>
	 *  
	 * @param dishChooserPanel
	 */
	public ListDishPanel(DishChooserPanel dishChooserPanel) {
		this.dishChooserPanel = dishChooserPanel;
		
		setBackground(Color.CYAN);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Disable layout
		setLayout(null);
		

		addComponents();
	}
	/**
	 * addComponents() creates a new JPanel to put inside a JScrollPane.<br>
	 * It creates a ListDishElement[] array from menu in MainGUI.<br>
	 * The new JPanel adds all elements from listDishElement[] and its listeners<br>
	 * 
	 */
	private void addComponents() {
		
		dishPanel = new JPanel();
		dishPanel.setLayout(null);

		scroll = new JScrollPane(dishPanel);
		
		makeList();
		

		for (int i = 0; i < listDishElements.length; i++) {
			
			
			dishPanel.add(listDishElements[i].dishName);
			listDishElements[i].dishName.setMargin(new Insets(0, 0, 0, 0)); //Disables margin between text and button borders
			listDishElements[i].dishName.addActionListener(this);
			
			dishPanel.add(listDishElements[i].minus);
			listDishElements[i].minus.setMargin(new Insets(0, 0, 0, 0)); //Disables margin between text and button borders
			listDishElements[i].minus.addActionListener(this);
			
			
			dishPanel.add(listDishElements[i].pluss);
			listDishElements[i].pluss.addActionListener(this);
			listDishElements[i].pluss.setMargin(new Insets(0, 0, 0, 0)); //Disables margin between text and button borders
			
			dishPanel.add(listDishElements[i].numberOfDishesField);
			listDishElements[i].numberOfDishesField.getDocument().addDocumentListener(this);

			dishPanel.add(listDishElements[i].endInfo);
		}
		add(scroll);

	}
	/**
	 * makeList fetches the menu[] from MainGUI and builds a ListDishElement[] from it
	 */
	private void makeList(){
		DishOb[] menu = dishChooserPanel.getOrderPanel().getGui().getMenu();
		menu = DishOb.sort(menu);
		PrintLine.println("ListDishPanel recived a menu of " + menu.length +" items");
		listDishElements = new ListDishElement[menu.length];
		for (int i = 0; i < menu.length; i++) {
			listDishElements[i] = new ListDishElement(menu[i]);
		}
	}
	/**
	 * Resets all number of wanted dishes to 0
	 */
	public void resetDish(){
		for (int i = 0; i < listDishElements.length; i++) {
			listDishElements[i].setNumberOfDishes(0);
			listDishElements[i].numberOfDishesField.setText("0");
		}
	}

	
	
//--Get and Set methods
	
	/**
	 * Returns DishComment for the last selected dish
	 */
	public String getDishComment() {
		return listDishElements[lastClickedItem].dish.getKommentar();
	}
	
	/**
	 * To be used while searching. Searching are done by setting the listDishElement 
	 * to false when its not going to be displayed.
	 * 
	 * @return list of dish elements
	 */
	public ListDishElement[] getListDishElements() {
		return listDishElements;
	}
	/**
	 * Returns a string of selected menuItems;
	 */
	public String buildReceiptPrice(){
		
		String result = "";
		for (int i = 0; i < listDishElements.length; i++) {
			if(listDishElements[i].numberOfDishes > 0){
				result += listDishElements[i].dishName.getText() + " " + listDishElements[i].numberOfDishes + listDishElements[i].endInfo.getText() + "\n";
			}
		}
		return result;
	}
	/**
	 * Return total price of all items without MVA
	 * @return result
	 */
	public double totalPriceWithoutMVA(){
		double result = 0;
		for (int i = 0; i < listDishElements.length; i++) {
			if(listDishElements[i].numberOfDishes > 0){
				result += listDishElements[i].dish.getPris()*listDishElements[i].numberOfDishes;
			}
		}
		return result;
	}
	
//--End Get and Set methods

//--Implemented Methods
	
	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void repaintPanel() {
		resizePanel(width, height);
	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void resizePanel(int width, int height) {
		this.width = width;
		this.height = height;
		
		dishPanel.setBounds(0, 0, width, height);
		
		int componentY = (new JLabel()).getFontMetrics(MainGUI.FONT).getHeight()+ 15; //Height of componenets
		int dishNameX = findLongestDishNameInt()+15;	//Dishname Length
		int minusX = componentY;	//Button for -
		int plussX = componentY;	//Button for +
		int numbOfX = 30;	//NumberOfOrders Length
		int endInfoX = (new JLabel()).getFontMetrics(MainGUI.FONT).stringWidth(" stk. ####.## kr.-  ###.## kr.-");	//End text length
		
		int YPos = 0;		//Linenumber of elements
		
		for (int i = 0; i < listDishElements.length; i++) {

			if(listDishElements[i].display){
				listDishElements[i].dishName.setBounds(0, YPos*componentY, dishNameX, componentY);
				listDishElements[i].minus.setBounds(dishNameX,YPos*componentY,minusX ,componentY);
				listDishElements[i].pluss.setBounds(dishNameX+minusX,YPos*componentY,plussX,componentY);
				listDishElements[i].numberOfDishesField.setBounds(dishNameX+minusX+plussX,YPos*componentY, numbOfX,componentY);
				listDishElements[i].endInfo.setBounds(dishNameX+minusX+plussX+numbOfX,YPos*componentY,endInfoX,componentY);
				
				YPos++;
			}
			else{ //Hide the elements
				listDishElements[i].dishName.setBounds(0, 0, 0, 0);
				listDishElements[i].minus.setBounds(0, 0, 0, 0);
				listDishElements[i].pluss.setBounds(0, 0, 0, 0);
				listDishElements[i].numberOfDishesField.setBounds(0, 0, 0, 0);
				listDishElements[i].endInfo.setBounds(0, 0, 0, 0);
			}
		}
		dishPanel.setPreferredSize(new Dimension(dishNameX+minusX+plussX+numbOfX+endInfoX, YPos*componentY));
		
		scroll.setViewportView(dishPanel);
		scroll.setBounds(0, 0, width, height);
		
	}
	
	/**
	 * Returns the pixellength of the longest DishName. (Used to find size of dishName button)
	 * @return
	 */
	private int findLongestDishNameInt(){
		int result = 30;
		int temp = 0;
		
		FontMetrics fm = (new JLabel()).getFontMetrics(MainGUI.FONT);
		for (int i = 0; i < listDishElements.length; i++) {
			temp = fm.stringWidth(listDishElements[i].dish.getRettnavn());
			if (temp > result){
				result = temp;
			}
		}
		return result;
	}
	
	final static int DISH_COMMENT = 1600;
	
	/**
	 * OP code for CommentDishPanel<br>
	 * DISH_COMMENT = 1600;
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		PrintLine.println("ListDishPanel button pressed " + ((JButton)e.getSource()).getText());
		for (int i = 0; i < listDishElements.length; i++) {
			if(e.getSource() == listDishElements[i].dishName){
				PrintLine.println("Menuname pressed " + i);
				lastClickedItem = i;
				dishChooserPanel.action(DISH_COMMENT);
			}
			else if(e.getSource() == listDishElements[i].minus){
				PrintLine.println("Minus pressed " + i);
				listDishElements[i].decrease();
			}
			else if(e.getSource() == listDishElements[i].pluss){
				PrintLine.println("Pluss pressed " + i);
				listDishElements[i].increase();
			}
		}
		dishChooserPanel.orderPanel.buildReceipt(); //Rebuilds receipt
		
	}


	@Override
	public void changedUpdate(DocumentEvent e) {changedTextField(e);}
	@Override
	public void insertUpdate(DocumentEvent e) {changedTextField(e);}
	@Override
	public void removeUpdate(DocumentEvent e) {changedTextField(e);}
	
	private void changedTextField(DocumentEvent e) {
		try {
			PrintLine.println("Document changed2 in ListDishPanel: " + e.getDocument().getText(0, e.getDocument().getLength()));
		} catch (BadLocationException e1) {
			e1.printStackTrace();
		}
		
		for (int i = 0; i < listDishElements.length; i++) {
			if(e.getDocument() == listDishElements[i].numberOfDishesField.getDocument()){
				
				//If no text, set number of items to 0
				if(e.getDocument().getLength() == 0){
					listDishElements[i].numberOfDishesField.setForeground(Color.BLACK);
					listDishElements[i].setNumberOfDishes(0);
				}else{
					
					//Try to convert to a number, if fails, set the JTextField to a red color
					try {
						int number = Integer.parseInt(e.getDocument().getText(0, e.getDocument().getLength()));
						listDishElements[i].numberOfDishesField.setForeground(Color.BLACK);
						listDishElements[i].setNumberOfDishes(number);
					} catch (BadLocationException e2) {
						e2.printStackTrace();
					} catch (NumberFormatException e2) {
						System.err.println("Can't convert string to integer in ListDishPanel");
						listDishElements[i].numberOfDishesField.setForeground(Color.RED);
					}			
				}
			}
		}
		dishChooserPanel.orderPanel.buildReceipt(); //Rebuilds receipt
	}


}

