package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

import no.ntnu.it1901.resturant.Objecter.CustomerOb;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.other.PrintLine;
/**
 * The ManualInputPanel is a subPanel of CustomerChooserPanel<br>
 * <br>
 * It's job is to call for searches based on the specific JTextFields. 
 * (Etc search in forename and telephone gives a search result with those two) 
 * @author ghenrik
 *
 */
public class ManualInputPanel extends JPanel implements PanelAdjustment, ActionListener, DocumentListener {
	
	//Parent Panel
	CustomerChooserPanel customerChooserPanel;
	
	JButton bNewCustomer, bReset;
	JTextField tForename, tSurname, tTelephone, tAddress, tPostCode, tTown; //Input from user
	JLabel lSearch;
	JLabel lForename, lSurname, lTelephone, lAddress, lPostCode, lTown;
	private final String 
		sForename 	= "Fornavn",
		sSurname 	= "Etternavn", 
		sTelephone 	= "Telefon", 
		sAddress 	= "Adresse", 
		sPostCode 	= "Postkode", 
		sTown 		= "By",
		sSearch		= "Sk etter kunde",
		sNewCustomer= "Ny Kunde",
		sReset 		= "Reset";
	
	//DocumentListener
	final static int FORENAME_CHANGED 	= 1101;
	final static int SURNAME_CHANGED  	= 1102;
	final static int TELEPHONE_CHANGED 	= 1103;
	final static int ADDRESS_CHANGED  	= 1104;	
	final static int POSTCODE_CHANGED 	= 1105;
	final static int TOWN_CHANGED  		= 1106;
	
	
	/**
	 * Initiates the ManualInputPanel, sets it's parent panel,
	 * sets layout to null, make the panel background opaque and
	 * adds the JLabel and JTextFields
	 * @param customerChooserPanel
	 */
	public ManualInputPanel(CustomerChooserPanel customerChooserPanel) {
		super();
		this.customerChooserPanel = customerChooserPanel;
		setBackground(Color.YELLOW);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Disable layout
		setLayout(null);
		
		addComponents();
	}
	/**
	 * Add the components to this JPanel
	 */
	private void addComponents(){
		
		bNewCustomer = new JButton(sNewCustomer);
		bNewCustomer.addActionListener(this);
		bNewCustomer.setEnabled(false); //Not usable until you write a first and last name
		
		bReset = new JButton(sReset);
		bReset.addActionListener(this);
		
		
		lSearch = new JLabel(sSearch);
		
		lForename = new JLabel(sForename);
		lSurname = new JLabel(sSurname);
		lTelephone = new JLabel(sTelephone);
		lAddress = new JLabel(sAddress);
		lPostCode = new JLabel(sPostCode);
		lTown = new JLabel(sTown);

		tForename = new JTextField();
		tSurname = new JTextField();
		tTelephone = new JTextField();
		tAddress = new JTextField();
		tPostCode = new JTextField();
		tTown = new JTextField();
		

		//Font
		lSearch.setFont(new Font(MainGUI.fontType, Font.BOLD, 15));
		lForename.setFont(MainGUI.FONT);
		lSurname.setFont(MainGUI.FONT);
		lTelephone.setFont(MainGUI.FONT);
		lAddress.setFont(MainGUI.FONT);
		lPostCode.setFont(MainGUI.FONT);
		lTown.setFont(MainGUI.FONT);
		tForename.setFont(MainGUI.FONT);
		tSurname.setFont(MainGUI.FONT);
		tTelephone.setFont(MainGUI.FONT);
		tAddress.setFont(MainGUI.FONT);
		tPostCode.setFont(MainGUI.FONT);
		tTown.setFont(MainGUI.FONT);
		bNewCustomer.setFont(MainGUI.FONT);
		bReset.setFont(MainGUI.FONT);
		
		//DocumentListner
		tForename.getDocument().addDocumentListener(this);
		tSurname.getDocument().addDocumentListener(this);
		tTelephone.getDocument().addDocumentListener(this);
		tAddress.getDocument().addDocumentListener(this);
		tPostCode.getDocument().addDocumentListener(this);
		tTown.getDocument().addDocumentListener(this);
		
		add(lSearch);
		
		add(lForename);
		add(lSurname);
		add(lTelephone);
		add(lAddress);
		add(lPostCode);
		add(lTown);
		
		add(tForename);
		add(tSurname);
		add(tTelephone);
		add(tAddress);
		add(tPostCode);
		add(tTown);
		
		add(bNewCustomer);
		add(bReset);
		
	}
	/**
	 * Resets input fields in ManualInputPanel
	 */
	public void resetTextFields() {
		tForename.setText("");
		tSurname.setText("");
		tTelephone.setText("");
		tAddress.setText("");
		tPostCode.setText("");
		tTown.setText("");
		
		customerChooserPanel.action(FORENAME_CHANGED);
	}
	
//--Get and Set methods
	
	/**
	 * Get new customer from input panel
	 */
	public CustomerOb getNewCustomer(){
		CustomerOb result = null;
		int postcode;
		try {
			 postcode = Integer.parseInt(getPostCode());
		} catch (Exception e){
			postcode = 0;
		}
		try {
			result =  new CustomerOb(getForename(), getSurname(), getAddress(), getTelephone(), getTown(), postcode);
		} catch (Exception e) {
			System.err.println("Could not create new customer from inputPanel");
			result = new CustomerOb("FeilFornavn","FeilEtternavn", "FeilAddresse","FeilTelefon","FeilBy",1234);
		}
		return result;
	}
	/**
	 * Return written Forename
	 */
	public String getForename() {
		return tForename.getText();
	}
	/**
	 * Return written Surname
	 */
	public String getSurname() {
		return tSurname.getText();
	}
	/**
	 * Return written TelephoneNumber
	 */
	public String getTelephone() {
		return tTelephone.getText();
	}
	/**
	 * Return written Address
	 */
	public String getAddress() {
		return tAddress.getText();
	}
	/**
	 * Return written PostCode
	 */
	public String getPostCode() {
		return tPostCode.getText();
	}
	/**
	 * Return written Town/Location
	 */
	public String getTown() {
		return tTown.getText();
	}

//--End Get and Set methods
	
//--Implemented Methods
	
  //PanelAdjustment
	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void resizePanel(int width, int height) {
		
		FontMetrics fm = lSearch.getFontMetrics(lSearch.getFont());
		
		int textAreaStart = width/2-20;
		int textHeight = fm.getHeight();
		int space = 5; //Space between TextFields;
		int panning = 5; //Space between JLabel and TextField
		int start = 50;
		int segment = 0;
		
		lSearch		.setBounds(width - fm.stringWidth(sSearch), start - fm.getHeight()-10, fm.stringWidth(sSearch), fm.getHeight());
		
		
		//Change FontMetrics for the smaller font
		fm = lForename.getFontMetrics(lForename.getFont()); 
		
		lForename	.setBounds(textAreaStart-fm.stringWidth(sForename) - panning, start + (textHeight+space)*segment++, fm.stringWidth(sForename), textHeight);
		lSurname	.setBounds(textAreaStart-fm.stringWidth(sSurname) - panning, start + (textHeight+space)*segment++, fm.stringWidth(sSurname), textHeight);
		lTelephone	.setBounds(textAreaStart-fm.stringWidth(sTelephone) - panning, start + (textHeight+space)*segment++, fm.stringWidth(sTelephone), textHeight);
		lAddress	.setBounds(textAreaStart-fm.stringWidth(sAddress) - panning, start + (textHeight+space)*segment++, fm.stringWidth(sAddress), textHeight);
		lPostCode	.setBounds(textAreaStart-fm.stringWidth(sPostCode) - panning, start + (textHeight+space)*segment++, fm.stringWidth(sPostCode), textHeight);
		lTown		.setBounds(textAreaStart-fm.stringWidth(sTown) - panning, start + (textHeight+space)*segment++, fm.stringWidth(sTown), textHeight);
		
		segment = 0; //reset
		
		tForename	.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		tSurname	.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		tTelephone	.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		tAddress	.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		tPostCode	.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		tTown		.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		bNewCustomer.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		bReset		.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		
	
	}
	
  //ActionListener
	public final static int NEW_CUSTOMER 		= 1100;
	
	@Override
	public void actionPerformed(ActionEvent e) {
		PrintLine.println("Button was pressed in ManualInputPanel: " + ((JButton)e.getSource()).getText());
		if(e.getSource() == bNewCustomer){
			customerChooserPanel.action(NEW_CUSTOMER);
		}
		else if(e.getSource() == bReset){
			resetTextFields();
		}
		else{
			System.err.println("Err: no action in ActionLister in ManualInputPanel connected to: " + e.getSource());
		}
	}




	
	/**
	 * The documentListner functions all send their DocumentEvent e to this method
	 * @param e
	 */
	private void changedTextField(DocumentEvent e) {
		int length = e.getDocument().getLength();
		try {
			PrintLine.println(e.getDocument().getText(0, length));
			if(e.getDocument() == tForename.getDocument()){
				customerChooserPanel.action(FORENAME_CHANGED);
				if (length == 0){
					bNewCustomer.setEnabled(false);
				}
			}
			else if(e.getDocument() == tSurname.getDocument()){
				if (length == 0){
					bNewCustomer.setEnabled(false);
				}	
				customerChooserPanel.action(SURNAME_CHANGED);
				
			}
			else if(e.getDocument() == tTelephone.getDocument()){
				confirmNumber(e);
				customerChooserPanel.action(TELEPHONE_CHANGED);
			}
			else if(e.getDocument() == tAddress.getDocument()){
				customerChooserPanel.action(ADDRESS_CHANGED);
			}
			else if(e.getDocument() == tPostCode.getDocument()){
				confirmNumber(e);
				customerChooserPanel.action(POSTCODE_CHANGED);
			}
			else if(e.getDocument() == tTown.getDocument()){
				customerChooserPanel.action(TOWN_CHANGED);
			}
			else{
				System.err.println("Err: no action in DocumentListner in ManualInputPanel connected to: " + e.getDocument());
			}
		} catch (BadLocationException e1) {
			System.err.println("Err: tried to get data from a TextField outside of Document length");
			e1.printStackTrace();
		}
		if (tForename.getDocument().getLength() != 0 && tSurname.getDocument().getLength() != 0){
			bNewCustomer.setEnabled(true);
		}
		
	}
	/**
	 * Confirms if telephone and post code is a valid number
	 * @param e
	 */
	private void confirmNumber(DocumentEvent e){

		if(e.getDocument() == tTelephone.getDocument()){
			if(tTelephone.getText().length() == 0){
				tTelephone.setForeground(Color.BLACK);
				bNewCustomer.setEnabled(true);
			}
			else{			
				try {
					Integer.parseInt(tTelephone.getText());
					tTelephone.setForeground(Color.BLACK);
					bNewCustomer.setEnabled(true);
				} catch (NumberFormatException e1) {
					tTelephone.setForeground(Color.RED);
					bNewCustomer.setEnabled(false);
				}
			}
		}
		else if(e.getDocument() == tPostCode.getDocument()){
			if(tPostCode.getText().length() == 0){
				tTelephone.setForeground(Color.BLACK);
				bNewCustomer.setEnabled(true);
			}
			else{
				try {
					Integer.parseInt(tPostCode.getText());
					tPostCode.setForeground(Color.BLACK);
					bNewCustomer.setEnabled(true);
				} catch (NumberFormatException e1) {
					tPostCode.setForeground(Color.RED);
					bNewCustomer.setEnabled(false);
				}				
			}
		}
		else{
			System.err.println("Err: Called to confirm number with an unsupported DocumentEvent e in confirmNumber in ManualInputPanel connected to: " + e.getDocument());
		}	
	}
	
	@Override
	public void changedUpdate(DocumentEvent e) {
		//This don't get called. I think. It's insertUpdate() 
		//and removeUpdate() that sends the DocumentEvent to changedTextField
		changedTextField(e); 
	}

	@Override
	public void insertUpdate(DocumentEvent e) {
		changedTextField(e);
	}

	@Override
	public void removeUpdate(DocumentEvent e) {
		changedTextField(e);
	}
	


}
