package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

import no.ntnu.it1901.resturant.Objecter.OrderOb;
import no.ntnu.it1901.resturant.Objecter.CustomerOb;
import no.ntnu.it1901.resturant.*;
import no.ntnu.it1901.resturant.UI.GUIMenuBar;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.UI.Delivery.DeliveryPanel;
import no.ntnu.it1901.resturant.other.PrintLine;
import no.ntnu.it1901.resturant.other.TextPrinter;
import no.ntnu.it1901.resturant.search.SearchCustomer;


/**
 * OrderPanel includes the main Registration and Ordering Setup.<br>
 * It is one of the sub panels from MainGui displays. 
 * Its job is to handle everything connected to picking a customer and selecting dish
 * 
 * @author ghenrik
 *
 */

public class OrderPanel extends JPanel implements PanelAdjustment {
	
	MainGUI gui;
	JLabel title, titleImage;
	String stringTitle = "Registrering";
	
	//Panels
	CustomerChooserPanel customerChooserPanel;
	DishChooserPanel dishChooserPanel;
	ReceiptPanel receiptPanel;
	
	//Search Class (Contains CustomerOb list)
	SearchCustomer searchCustomer;
	
	/**
	 * Initiates the OrderPanel and its subPanels CustomerChooserPanel, DishChooserPanel
	 * and ReceiptPanel
	 * 
	 * @param gui
	 */
	public OrderPanel(MainGUI gui, CustomerOb[] customers) {
		
		this.gui = gui;
		this.setBackground(Color.LIGHT_GRAY);
		searchCustomer = new SearchCustomer(customers);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Disable the layoutManager
		setLayout(null);
		
		//PanelImage and title

		ClassLoader cldr = this.getClass().getClassLoader();
		java.net.URL imageURL   = cldr.getResource("img\\logo.png");
		
		if (imageURL==null){
			
	
			imageURL   = cldr.getResource("no/ntnu/it1901/resturant/img/logo.png");
			}titleImage = new JLabel(new ImageIcon(imageURL));

		title = new JLabel(stringTitle);
		title.setFont(new Font(MainGUI.fontType, Font.BOLD, 20));
		title.setForeground(Color.WHITE);
		
		//Sub Panels
		customerChooserPanel = new CustomerChooserPanel(this);
		dishChooserPanel = new DishChooserPanel(this);
		receiptPanel = new ReceiptPanel(this);
		
				
		add(title);
		add(titleImage);
		add(customerChooserPanel);
		add(dishChooserPanel);
		add(receiptPanel);
	}
	
//--Get and Set methods
	/**
	 * On new customer added to database, retrieve it to insert it to list
	 */
	public void setSingleCustomer(CustomerOb customer){
		searchCustomer.setSingleCustomer(customer);
		
		//Search for the customer in the new array
		customerChooserPanel.searchManual();
		
	}
	
	/**
	 * Returns the parent panel MainGUI
	 */
	public MainGUI getGui() {
		return gui;
	}
	/**
	 * Starts building the complete receipt and sends it to receiptPanel
	 */
	public void buildReceipt(){
		PrintLine.println("Building receipt");
		receiptPanel.setNameReceipt(buildReceiptName());
		receiptPanel.setPriceReceipt(buildReceiptPrice());
		String output[] = (buildReceiptName()+buildReceiptPrice()).split("\n");
		for (int i = 0; i < output.length; i++) {
			System.out.println(output[i]);
		}
	}
	/**
	 * Sends receipt string to printer
	 */
	
	public void printReceipt(){
		PrintLine.println("Starting print job of receipt");
		//Print
		new TextPrinter(buildReceiptName() +"\n"+ buildReceiptPrice());
	}
	
	/**
	 * When order is completed, reset orderpanel
	 */
	public void resetOrder(){
		customerChooserPanel.resetOrder();
		dishChooserPanel.resetOrder();
		receiptPanel.resetOrder();
	}
	
	/**
	 * Return picked Customer with edited changes.
	 * @return picked customer
	 */
	public CustomerOb getPickedCustomer(){
		return customerChooserPanel.getPickedCustomer();
	}	
	/**
	 * Edits a customer based on customerID
	 */
	public void editCustomer(CustomerOb customer){
		searchCustomer.editCustomer(customer);
		customerChooserPanel.searchManual();
	}
	/**
	 * Get new customer from input panel
	 */
	public CustomerOb getNewCustomer(){
		return customerChooserPanel.getNewCustomer();
	}
	/**
	 * Starts building the receipt name part from CustomerChooserPanel
	 */
	public String buildReceiptName(){
		String result = "";
		result += "Kvittering fra " + gui.getRestaurantName() + "\n";
		result += "Tid: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()) + "\n\n";
		result += customerChooserPanel.buildReceiptName();
		return result;
	}
	/**
	 * Starts building the receipt price part from DishChooserPanel
	 */
	public String buildReceiptPrice(){
		
		DecimalFormat df = new DecimalFormat("#.##");
		String result = "";
		result += dishChooserPanel.buildReceiptPrice();
		
		double totalWithoutMVA = dishChooserPanel.totalPriceWithoutMVA();
		
		result += "\nSum: " + df.format(totalWithoutMVA) + "kr,-\n";

		float deliveryPrice = 0;
		if(receiptPanel.isNoDelivery()){
			result += "Kunde vil hente ordre selv, ingen levering\n";
		}else{
			if(totalWithoutMVA <= gui.getDeliveryFree() ){
				deliveryPrice = gui.getDeliveryPrice();
			}			
			result += "Leverings Kostnader: " + df.format(deliveryPrice) + " kr,-\n";
		}
		
		totalWithoutMVA += deliveryPrice;
		
		result += "Total uten MVA: " + df.format(totalWithoutMVA) +"\n";
		result += "Sum med MVA 25%: " + df.format(totalWithoutMVA* 1.25)+"\n";
		return result;	
	}
	
	/**
	 * Builds and return the complete order from Orderpanel
	 */	
	public OrderOb getNewOrder() {
		OrderOb result = new OrderOb(
				-1, //Fake order id, the database creates it
				customerChooserPanel.getPickedCustomer().getKundeId(),
				new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()),
				dishChooserPanel.getOrdersDishes(),
				-1, //Dish is not completed
				receiptPanel.receiptSettingPanel.isNoDelivery() ? 0 : 1,
				dishChooserPanel.getCommentOrder()
				);
		
		return result;
	}

//--End Get and Set methods
	
//--Implemented methods
	
	@Override
	public void action(int opCode) {
		PrintLine.println("OrderPanel recived action opCode: " + opCode);
		
		switch (opCode) {
		case ReceiptSettingPanel.PRINT_RECEIPT:
			printReceipt();
			break;
			
		default:
			PrintLine.println("OrderPanel don't know what to do with opCode: " + opCode);
			break;
		}

	}

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub

	}

	@Override
	public void requestRefresh() {
		dishChooserPanel.recreateListDishPanel();

	}

	@Override
	public void resizePanel(int width, int height) {
		
		//Get the font size
		FontMetrics fm = title.getFontMetrics(title.getFont());
		int titleWidth = fm.stringWidth(title.getText());
		int titleHeight = fm.getHeight();
		
		title.setBounds(170/2-titleWidth/2,70/2-titleHeight/2,titleWidth,titleHeight);
		titleImage.setBounds(0,0,1301,75);
		
		//Panels
		int border = 15; //Border around window

		int customerChooserPanelWidth = ((width-border*3)/3)*2;
		int customerChooserPanelHeight = ((height-75-border*2)/3)*2;
		
		int dishChooserPanelWidth = width - customerChooserPanelWidth - 3*border;
		int dishChooserPanelHeight = height-border*2 - 75;
		
		int receiptPanelWidth = customerChooserPanelWidth;
		int receiptPanelHeight = height - customerChooserPanelHeight - border*3 - 75;
		
		customerChooserPanel.setBounds(border, 75+border, customerChooserPanelWidth, customerChooserPanelHeight);
		customerChooserPanel.resizePanel(customerChooserPanelWidth, customerChooserPanelHeight);
		
		dishChooserPanel.setBounds(border*2 + customerChooserPanelWidth, 75+border, dishChooserPanelWidth, dishChooserPanelHeight);
		dishChooserPanel.resizePanel(dishChooserPanelWidth, dishChooserPanelHeight);

		receiptPanel.setBounds(border, 75+border*2 +customerChooserPanelHeight, receiptPanelWidth, receiptPanelHeight);
		receiptPanel.resizePanel(receiptPanelWidth, receiptPanelHeight);
	}



}
