package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;


/**
 * The ReceiptPanel is a subPanel of OrderPanel<br>
 * ReceiptPanel includes the receipt area and final settings for order<br>
 * It is one of the sub panels from MainGui displays. 
 * Its job is to be refreshed and catch all info when something relevant to it changes
 * Contains the sub panels ReceiptResultPanel and ReceiptSettingPanel<br>
 * 
 * @author ghenrik
 *
 */

public class ReceiptPanel extends JPanel implements PanelAdjustment {
	
	OrderPanel orderPanel;
	
	ReceiptResultPanel receiptResultPanel;
	ReceiptSettingPanel receiptSettingPanel;
	
	String sBorderTitle = "Kvittering";
	/**
	 * Initiates ReseiptPanel and its subPanels ReceiptResultPanel and ReceiptSettingPanel.
	 */
	public ReceiptPanel(OrderPanel orderPanel){
		this.orderPanel = orderPanel;
		
		this.setBackground(Color.BLUE);
		
		TitledBorder tb = BorderFactory.createTitledBorder(sBorderTitle);
		setBorder(tb);
		
		//Disable the layoutManager
		setLayout(null);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Sub Panels
		receiptResultPanel = new ReceiptResultPanel(this);
		receiptSettingPanel = new ReceiptSettingPanel(this);
		
		add(receiptResultPanel);
		add(receiptSettingPanel);
	}
	
	/**
	 * When order is completed, reset takeaway button
	 */
	public void resetOrder() {
		receiptSettingPanel.selfPickUp.setSelected(false);
		
	}
//--Get and Set methods	
	/**
	 * Sets the name section of the receipt
	 * @param string
	 */
	public void setNameReceipt(String string) {
		receiptResultPanel.setNameReceipt(string);
	}
	/**
	 * Sets the price section of the receipt
	 * @param string
	 */
	public void setPriceReceipt(String string){
		receiptResultPanel.setPriceReceipt(string);	
	}
	/**
	 * Checks if person wants to pick up order himself
	 * 
	 * @return isNoDelivery()
	 */
	public boolean isNoDelivery() {
		
		return receiptSettingPanel.isNoDelivery();
	}
//--End Get and Set methods
	
//--Implemented methods
	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void resizePanel(int width, int height) {
		int border = 10;
		int upperBorder = 20; //Need some more space due to border title
			
		int receiptSettingPanelWidth = 160; //In line with PickedCustomerPanel
		int receiptSettingPanelHeight = height - border - upperBorder;
		int receiptResultPanelWidth = width - receiptSettingPanelWidth - border*2;
		int receiptResultPanelHeight = height - border - upperBorder;

		
		receiptResultPanel.setBounds(border, upperBorder, receiptResultPanelWidth, receiptResultPanelHeight);
		receiptResultPanel.resizePanel(receiptResultPanelWidth, receiptResultPanelHeight);
		
		receiptSettingPanel.setBounds(border + receiptResultPanelWidth, upperBorder, receiptSettingPanelWidth, receiptSettingPanelHeight);
		receiptSettingPanel.resizePanel(receiptSettingPanelWidth, receiptSettingPanelHeight);
		
	}

}
