package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;

import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;

/**
 * The ReceiptResultPanel is a subPanel of ReceiptPanel<br>
 * <br>
 * It's job is to retrieve and display the receipt with
 * name of customer and price.
 * @author ghenrik
 *
 */
public class ReceiptResultPanel extends JPanel implements PanelAdjustment {
	
	ReceiptPanel receiptPanel;
	
	JTextPane nameReceipt, costReceipt;
	JScrollPane scrollNameReceipt, scrollCostReceipt;

	/**
	 * Initiates the ReceiptResultPanel, sets it's parent panel,
	 * sets layout to null, make the panel background opaque and
	 * adds the two JTextPane inside JScrollPane.
	 * @param receiptPanel
	 */
	public ReceiptResultPanel(ReceiptPanel receiptPanel) {
		this.receiptPanel = receiptPanel;
		
		this.setBackground(Color.GREEN);
		
		//Disable the layoutManager
		setLayout(null);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		addComponents();
		
	}
	/**
	 * Add the components to this JPanel
	 */	
	private void addComponents() {
		
		nameReceipt = new JTextPane();
		costReceipt = new JTextPane();
		
		scrollNameReceipt = new JScrollPane(nameReceipt);
		scrollCostReceipt = new JScrollPane(costReceipt);
		
		nameReceipt.setFont(MainGUI.FONT);
		costReceipt.setFont(MainGUI.FONT);
		
		nameReceipt.setEditable(false);
		costReceipt.setEditable(false);
		
		add(scrollNameReceipt);
		add(scrollCostReceipt);
	}
//--Get and Set methods	
	/**
	 * Sets the name section of the receipt
	 * @param string
	 */
	public void setNameReceipt(String string) {
		nameReceipt.setText(string);
	}
	/**
	 * Sets the price section of the receipt
	 * @param string
	 */
	public void setPriceReceipt(String string){
		costReceipt.setText(string);
	}
//--End Get and Set methods
	
//--Implemented methods
	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub

	}

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub

	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub

	}

	@Override
	public void resizePanel(int width, int height) {
		
		scrollNameReceipt.setBounds(0, 0, width/2, height);
		scrollCostReceipt.setBounds(width/2, 0, width - width/2, height);

	}

}
