package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;

import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.other.PrintLine;

/**
 * The ReceiptSettingPanel is a subPanel of ReceiptPanel<br>
 * <br>
 * It's job is to retrieve and display the receipt with
 * name of customer and price.
 * @author ghenrik
 *
 */
public class ReceiptSettingPanel extends JPanel implements PanelAdjustment, ActionListener{
	
	ReceiptPanel receiptPanel;
	
	JCheckBox selfPickUp;
	JButton print;
	String 
		sSelfPickUp = "Henter selv",
		sPrint = "Print";
	

	/**
	 * Initiates the ReceiptSettingPanel, sets it's parent panel,
	 * sets layout to null, make the panel background opaque and
	 * adds the two JTextPane inside JScrollPane.
	 * @param receiptPanel
	 */
	public ReceiptSettingPanel(ReceiptPanel receiptPanel) {
		this.receiptPanel = receiptPanel;
		
		this.setBackground(Color.RED);
		
		//Disable the layoutManager
		setLayout(null);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		addComponents();
		
	}
	/**
	 * Add the components to this JPanel
	 */	
	private void addComponents() {
		
		selfPickUp = new JCheckBox(sSelfPickUp);
		selfPickUp.setFont(MainGUI.FONT);
		selfPickUp.addActionListener(this);
		
		print = new JButton(sPrint);
		print.setFont(MainGUI.FONT);
		print.addActionListener(this);
		
		
		add(selfPickUp);
		add(print);
		
	}
	
	/**
	 * Checks if customer wants to pick up order himself
	 * @return isSelected()
	 */
	public boolean isNoDelivery() {
		
		return selfPickUp.isSelected();
	}
	
	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub

	}

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub

	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub

	}

	@Override
	public void resizePanel(int width, int height) {
		
		int componentHeight = selfPickUp.getFontMetrics(MainGUI.FONT).getHeight();
		int componentWidth = selfPickUp.getFontMetrics(MainGUI.FONT).stringWidth(sSelfPickUp);
		selfPickUp.setBounds(0, 0, componentWidth + 30, componentHeight);
		
		print.setBounds(0, height - componentHeight*2, width, componentHeight*2);
	}
	
	
	final static int PRINT_RECEIPT = 1800;
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == print){
			PrintLine.println("ReceiptResultPanel pressed button " + print.getText() );
			receiptPanel.orderPanel.action(PRINT_RECEIPT);
		}
		else if(e.getSource() == selfPickUp){
			receiptPanel.orderPanel.buildReceipt(); //rebuilds receipt
		}
		else{
			PrintLine.println("ReceiptResultPanel dont know what to do with actionevent");
		}
		
	}


}
