package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.other.PrintLine;

/**
 * The SearchCustomerPanel is a subPanel of CustomerChooserPanel<br>
 * <br>
 * It's job is to call for searches based on a general search. 
 * (Etc a search will go and find the a instance of the search in forename, surname, telephone, postcode, address and town) 
 * @author ghenrik
 *
 */
public class SearchCustomerPanel extends JPanel implements PanelAdjustment, DocumentListener {
	
	CustomerChooserPanel customerChooserPanel;
	
	JTextField searchBar;
	/**
	 * Initiates the SearchCustomerPanel, sets it's parent panel,
	 * sets layout to null, make the panel background opaque and
	 * adds the JTextField
	 * @param customerChooserPanel
	 */
	public SearchCustomerPanel(CustomerChooserPanel customerChooserPanel) {
		super();
		this.customerChooserPanel = customerChooserPanel;
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Disable layout
		setLayout(null);
		setBackground(Color.GREEN);
		
		addComponents();
	}
	
	/**
	 * Add the components to this JPanel
	 */	
	private void addComponents() {
		searchBar = new JTextField();
		searchBar.getDocument().addDocumentListener(this);
		add(searchBar);
	}
	
//--Get and Set methods

	public String getSearchBar() {
		return searchBar.getText();
	}
	
//--End Get and Set methods
	
//--Implemented Methods
	
  //PanelAdjustment
	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void resizePanel(int width, int height) {
		searchBar.setBounds(0, height-30, width, 20);
		//searchBar.setBounds(10, height-30, width-20, 20);
	}

  //DocumentListener
	
	final static int GENERAL_SEARCH = 1200;
	/**
	 * The documentListner functions all send their DocumentEvent e to this method
	 * @param e
	 */
	private void changedTextField(DocumentEvent e) {
		int length = e.getDocument().getLength();
		try {
			PrintLine.println("Field in SearchCustomerPanel changed to: " + e.getDocument().getText(0, length));
			if(e.getDocument() == searchBar.getDocument()){
				customerChooserPanel.action(GENERAL_SEARCH);
			}
			else{
				System.err.println("Err: no action in DocumentListner in ManualInputPanel connected to: " + e.getDocument());
			}
		} catch (BadLocationException e1) {
			System.err.println("Err: tried to get data from a TextField outside of Document length");
			e1.printStackTrace();
		}	
		
	}
	@Override
	public void changedUpdate(DocumentEvent e) {
		//This don't get called. I think. It's insertUpdate() 
		//and removeUpdate() that sends the DocumentEvent to changedTextField
		changedTextField(e); 
	}

	@Override
	public void insertUpdate(DocumentEvent e) {
		changedTextField(e);
	}

	@Override
	public void removeUpdate(DocumentEvent e) {
		changedTextField(e);
	}
	


}
