package no.ntnu.it1901.resturant.UI.Settings;

import java.awt.Color;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import no.ntnu.it1901.resturant.Objecter.DishOb;
import no.ntnu.it1901.resturant.UI.GUIMenuBar;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.UI.Delivery.DeliveryPanel;
import no.ntnu.it1901.resturant.other.PrintLine;
/**
 * Allows changes in program. For now its only to add a dish
 * AdminSettingsPanel includes the NewDishPanel<br>
 * It is one of the sub panels from MainGui displays. 
 * Its job is to contain the different settingPanels
 * @author ghenrik
 *
 */
public class AdminSettingPanel extends JPanel implements PanelAdjustment {
	
	//Parent Panel
	MainGUI gui;
	
	NewDishPanel newDishPanel;
	
	/**
	 * Initiates the AdminSettingPanel and its subPanels NewDishPanel
	 * 
	 * @param gui
	 */	
	public AdminSettingPanel(MainGUI gui) {
		this.gui = gui;
		
		setBackground(Color.GREEN);
				
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Disable layout
		setLayout(null);
		
		addComponents();
	}

	private void addComponents() {
		newDishPanel = new NewDishPanel(this);
		add(newDishPanel);
		
	}
	//--Get and Set methods
	/**
	 * Returns an DishOb with the new dish to be included in database.
	 */
	public DishOb getNewDish(){
		return newDishPanel.getNewDish();
	}
	//--End Get and Set methods
	@Override
	public void action(int opCode) {
		
		PrintLine.println("AdminSettingPanel recived action opCode: " + opCode);
		
		switch (opCode) {
		case NewDishPanel.NEW_DISH:
			gui.notifyController(NewDishPanel.NEW_DISH, -1);
			break;
			
		default:
			PrintLine.println("MainGUI don't know what to do with opCode: " + opCode);
			break;
		}
	}

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub

	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub

	}

	@Override
	public void resizePanel(int width, int height) {
		int segmentSize = height/4;
		newDishPanel.setBounds(0, 0, width, segmentSize);
		newDishPanel.resizePanel(width, height);

	}

}
