package no.ntnu.it1901.resturant.UI.Settings;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

import no.ntnu.it1901.resturant.Objecter.DishOb;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.other.PrintLine;

/**
 * Allows changes in program. For now its only to add a dish<br>
 * It is one of the sub panels from MainGui displays. 
 * Its job is to contain setting for adding a new dish
 * @author ghenrik
 *
 */

public class NewDishPanel extends JPanel implements PanelAdjustment, ActionListener, DocumentListener {
	
	//Parent panel
	AdminSettingPanel adminSettingPanel;
	
	JLabel lName, lComment, lPrice;
	JTextField fName, fComment, fPrice;
	JButton bAddDish;
	private final String 
		sName 		= "Matrett Navn",
		sComment	= "Kommentar",
		sPrice		= "Pris",
		sButton		= "Legg til",
		sBorderTitle= "Legg til ny matrett";
	/**
	 * Initiates the NewDishPanel
	 * 
	 * @param adminSettingPanel
	 */		
	public NewDishPanel(AdminSettingPanel adminSettingPanel) {
		this.adminSettingPanel = adminSettingPanel;
		
		setBackground(Color.YELLOW);
		
		TitledBorder tb = BorderFactory.createTitledBorder(sBorderTitle);
		setBorder(tb);	
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Disable layout
		setLayout(null);
		
		addComponents();
	}

	private void addComponents() {
		lName = new JLabel(sName);
		lName.setFont(MainGUI.FONT);
		lComment = new JLabel(sComment);
		lComment.setFont(MainGUI.FONT);
		lPrice = new JLabel(sPrice);
		lPrice.setFont(MainGUI.FONT);
		
		fName = new JTextField();
		fName.setFont(MainGUI.FONT);
		fComment = new JTextField();
		fComment.setFont(MainGUI.FONT);
		fPrice = new JTextField();
		fPrice.setFont(MainGUI.FONT);
		fPrice.getDocument().addDocumentListener(this);
		
		bAddDish = new JButton(sButton);
		bAddDish.addActionListener(this);
		bAddDish.setEnabled(false);
		
		add(lName);
		add(lComment);
		add(lPrice);
		add(fName);
		add(fComment);
		add(fPrice);
		add(bAddDish);
		
		
	}
	//--Get and Set methods
	/**
	 * Returns an DishOb with the new object.
	 */
	public DishOb getNewDish(){
		return new DishOb(Double.parseDouble(fPrice.getText()), fName.getText(), fComment.getText());
	}
	
	//--End Get and Set methods
	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void resizePanel(int width, int height) {
		FontMetrics fm = lName.getFontMetrics(lName.getFont());
		
		int textAreaStart = 120;
		int textHeight = fm.getHeight()+10;
		int space = 5; //Space between TextFields;
		int panning = 5; //Space between JLabel and TextField
		int start = 15;
		int segment = 0;
		
		lName	.setBounds(textAreaStart-fm.stringWidth(sName) - panning, start + (textHeight+space)*segment++, fm.stringWidth(sName), textHeight);
		lComment.setBounds(textAreaStart-fm.stringWidth(sComment) - panning, start + (textHeight+space)*segment++, fm.stringWidth(sComment), textHeight);
		lPrice	.setBounds(textAreaStart-fm.stringWidth(sPrice) - panning, start + (textHeight+space)*segment++, fm.stringWidth(sPrice), textHeight);

		
		segment = 0; //reset
		
		fName	.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart-start, textHeight);
		fComment.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart-start, textHeight);
		fPrice	.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart-start, textHeight);
		bAddDish.setBounds(textAreaStart, start + (textHeight+space)*segment++, 100, textHeight);
		
	}
	
	public final static int NEW_DISH 		= 4000;
	
	@Override
	public void actionPerformed(ActionEvent e) {
		PrintLine.println("Button was pressed in NewDishPanel: " + ((JButton)e.getSource()).getText());
		if(e.getSource() == bAddDish){
			adminSettingPanel.gui.notifyController(NEW_DISH, -1);
		}
		else{
			System.err.println("Err: no action in ActionLister in ManualInputPanel connected to: " + e.getSource());
		}
		
	}

	/**
	 * The documentListner functions all send their DocumentEvent e to this method
	 * @param e
	 */
	private void changedTextField(DocumentEvent e) {
		int length = e.getDocument().getLength();
		try {
			PrintLine.println(e.getDocument().getText(0, length));
			if(e.getDocument() == fPrice.getDocument()){
				//Try to convert to a number, if fails, set the JTextField to a red color
				try {
					Float.parseFloat(e.getDocument().getText(0, e.getDocument().getLength()));
					fPrice.setForeground(Color.BLACK);
					bAddDish.setEnabled(true);
				} catch (BadLocationException e2) {
					e2.printStackTrace();
				} catch (NumberFormatException e2) {
					System.err.println("Can't convert string to integer in ListDishPanel");
					fPrice.setForeground(Color.RED);
					bAddDish.setEnabled(false);
				}
			}
			else{
				System.err.println("Err: no action in DocumentListner in ManualInputPanel connected to: " + e.getDocument());
			}
		} catch (BadLocationException e1) {
			System.err.println("Err: tried to get data from a TextField outside of Document length");
			e1.printStackTrace();
		}	
		
	}
	@Override
	public void changedUpdate(DocumentEvent e) {
		//This don't get called. I think. It's insertUpdate() 
		//and removeUpdate() that sends the DocumentEvent to changedTextField
		changedTextField(e); 
	}

	@Override
	public void insertUpdate(DocumentEvent e) {
		changedTextField(e);
	}

	@Override
	public void removeUpdate(DocumentEvent e) {
		changedTextField(e);
	}

}
