package no.ntnu.it1901.resturant.controller;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import no.ntnu.it1901.resturant.Objecter.DishOb;
import no.ntnu.it1901.resturant.Objecter.OrderOb;
import no.ntnu.it1901.resturant.Objecter.CustomerOb;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.Chef.ChefPanel;
import no.ntnu.it1901.resturant.UI.Delivery.DeliveryPanel;
import no.ntnu.it1901.resturant.UI.Order.CommentDishPanel;
import no.ntnu.it1901.resturant.UI.Order.ManualInputPanel;
import no.ntnu.it1901.resturant.UI.Order.PickedCustomerPanel;
import no.ntnu.it1901.resturant.UI.Settings.NewDishPanel;
import no.ntnu.it1901.resturant.database.Order;
import no.ntnu.it1901.resturant.database.Customer;
import no.ntnu.it1901.resturant.database.Dish;
import no.ntnu.it1901.resturant.other.PrintLine;

/**
 * The controller connects to database, fetch some data and transfer it to main gui that starts up.<br>
 * It then idles while it waits for calls from mainGUI.<br>
 * On call from mainGUI, it does the expected calls to database and return data to gui.
 * @author ghenrik
 *
 */
public class Controller {
	
	//default connection settings
	public static String port = "1527"; //Default port
	public static String database = "//localhost"; //Default database location

	
	public static java.sql.Connection con = null;
	public static MainGUI gui = null;
	public Controller() {
		CreateConnection();
		gui = new MainGUI(this, Dish.getMenu(),Customer.getAllCustomers(),null);
	}
	/**
	 * Creates a connection to the database
	 * Finds the info in the config.txt file, else uses default(localhost and 1527)
	 */
	public static void CreateConnection() {
		try {
			//reads the location and port of the database from the config.txt file
			Properties configFile = new Properties();
			File file = new File("config.txt");
			if(file.exists()){
					configFile.load(new FileReader(file));
					PrintLine.println("Reading Properties:");
					
					String tempPort = configFile.getProperty("PORT");
					String tempDatabase = configFile.getProperty("DATABASE");
					if(port != null && port.length() > 0){
							port = tempPort;
							PrintLine.println("\tConnection on port: " + port);
					}else{
						PrintLine.println("\tCould not find PORT and its key in config.txt, defaults to: " + port);
					}
					if(database != null && database.length() > 0){
						database = tempDatabase;
						PrintLine.println("\tConnection to database at location: " + database);
					}else{
						PrintLine.println("\tCould not find DATABASE and its key in config.txt, defaults to: " + database);
					}
			}
				else{
					PrintLine.println("Could not find config.txt file. Default values taken instead. (Could the move from GUI2 to GUI package be the problem?)");
				}
			
			// Creates a connection to the database
			Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
			con = DriverManager.getConnection("jdbc:derby:" + database + ":" + port + "/it1901");
			
		}catch (SQLException e) {
			System.err.println("database error in createConnetionc");
		}catch (FileNotFoundException e) {
			System.out.println("Could not find file for config.");
			e.printStackTrace();
		} catch (IOException e) {
			System.out.println("Failed to read file. Its there, its just borked.");
			e.printStackTrace();
		}catch (Exception e) {
			System.err.println("Connection til databasen ikke opprettet!!");
		}
	}
	/**
	 * MainGUI calls notify change when it wants to add or fetch data from database
	 * @param opCode
	 * @param givenIdentification
	 */
	public void notifyChange(int opCode, int givenIdentification){
		PrintLine.println("Controller recived opCode: " + opCode + ", and ID: " + givenIdentification);	
		switch (opCode) {
		case ManualInputPanel.NEW_CUSTOMER:
			
			newCustomer();
			break;
			
		case CommentDishPanel.COMPLETE_ORDER:
			
			completeOrder();
			
			break;

		case NewDishPanel.NEW_DISH:
			
			newDish();
			break;
			
		case PickedCustomerPanel.EDIT_CUSTOMER:
			
			editCustomer();
			break;
			
		case ChefPanel.COMPLETE_CHEF:
			
			completeChef(givenIdentification);
			break;
			
		case ChefPanel.GET_UFERDIGE_ORDERS:
			
			getUncompletedOrders();
			break;
			
		case DeliveryPanel.GET_COMPLETED_ORDERS:
			
			getCompletedOrders();

		default:
			break;
		}
	}
	/**
	 * get completed orders
	 */
	private void getCompletedOrders() {
		
		DeliveryPanel.unfinishedOrders = Order.getUleverteBestillinger();
	}
	/**
	 * Get uncompleted orders
	 */
	private void getUncompletedOrders() {
		ChefPanel.chefOrder = Order.getUferdigBestillinger();
	}
	
	/**
	 * Complete Chefs orders
	 */
	private void completeChef(int opCode){
		Order.settFerdigBestilling(opCode);
	}
	
	/**
	 * Edit a customer in database
	 */
	private void editCustomer() {
		CustomerOb editedCustomer = gui.getPickedCustomer();
		int result = Customer.changeCustomer(editedCustomer);
		if(result != -1){
			gui.editCustomer(editedCustomer);
			gui.warningMessage("Kunde er endret");
		}
		else{
			gui.warningMessage("Kunde ble ikke endret i databasen");
		}
	}
	/**
	 * Retrieve new dish from main gui, add to database, if successful, add back dish to MainGUI list
	 */
	private void newDish() {
		
		DishOb dish = gui.getNewDish();
		
		int result = Dish.addDish(dish.getPris(), dish.getRettnavn(), dish.getKommentar());
		
		if(result != -1){
			dish.setRettId(result);
			gui.addNewDish(dish);
			gui.warningMessage("Matrett ble lagt til");
		}
		else{
			gui.warningMessage("Matrett ble ikke lagt til i databasen");
		}
	}

	/**
	 * Retrieves OrderOb from OrderPanel<br>
	 * Extract data from bestillingsOb and calls database
	 */
	private void completeOrder() {
		
		boolean confirmOrder = false;
		OrderOb order = gui.getNewOrder();
		confirmOrder = Order.leggTilBestilling(order.getKundeId(), order.getMatretter(), order.getKommentar(), order.getLevert());
		System.err.println(confirmOrder);
		if(confirmOrder){
			gui.warningMessage("Ordre er lagt til");
			gui.resetOrder();
			gui.chefPanel.newOrder();
		
			
		}
		else{
			gui.warningMessage("Kunne ikke legge til ordre i database");
		}	
		
	}

	/**
	 * Retrieve customer from manualInputPanel<br>
	 * Creates new customer in database<br>
	 * Retrieves new customerId from database<br>
	 * Adds customer to customerList in GUI
	 */
	private void newCustomer() {
		System.out.println("FinnerKunde");
		CustomerOb customer = gui.getNewCustomer();
		if (customer != null){
		System.out.println("Fant kunde"+customer.toString());
		}
		//Mangler postSted nr kunde legges til. Skal genereres automatisk ut
		//ifra postnummer men godt mulig at det ikke vil bli lagt inn i ferdig program
		int kundeid = Customer.addCustomer(customer.getFornavn(), customer.getEtternavn(), customer.getAdresse(), customer.getTelefon(), customer.getPostnummer(), customer.getPoststed());
		System.out.println(kundeid);
		if(kundeid >= 0){
			gui.setSingleCustomer(new CustomerOb(customer.getFornavn(), customer.getEtternavn(), customer.getAdresse(), customer.getTelefon(), customer.getPoststed(), customer.getPostnummer(),kundeid));
		}
		else{
			gui.warningMessage("Could not add new customer to database");
		}
	}
	
	
	/**
	 * Starts controller and mainGUI
	 * @param args
	 */
	public static void main(String[] args) {
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				try {
					UIManager.setLookAndFeel( UIManager.getSystemLookAndFeelClassName());  //Change theme to OS one
			    } 
			    catch (UnsupportedLookAndFeelException e) {}
			    catch (ClassNotFoundException e) {}
			    catch (InstantiationException e) {}
			    catch (IllegalAccessException e) {}

			    new Controller();
				
			}

		});	
	}
	
}
