package no.ntnu.it1901.resturant.database;
import java.sql.*;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.Arrays.*;

import no.ntnu.it1901.resturant.Objecter.CustomerOb;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.controller.Controller;
import no.ntnu.it1901.resturant.other.PrintLine;

/**
 * Methods for accessing and changing the kunde table in the database
 * 
 * Contains helper methods for the constructor in CustomerOb, 
 * and methods used by the controller
 * 
 * @author Arnfinn
 * @author Glover
 * @version 1.7 11.11.2010
 */
public class Customer  {
	private static Statement stmt;

	/**
	 * Gets all the info for a CustomerOb in the database, and creates the object. 
	 * @param kunde_id customer_id of one customer
	 * @return CustomerOb a customer (null if customer don't exist)
	 */
	public static CustomerOb createCustomerObject(int kunde_id){
		try {
			ResultSet rs;
			
			//Gets the customer with from kunde_id (primary key)
			stmt = Controller.con.createStatement();
			rs = stmt.executeQuery("SELECT * FROM kunde WHERE kunde_id = " + kunde_id);
			CustomerOb result = new CustomerOb("KundeId finnes ikke", "error", 
					"KundeId finnes ikke","error", "KundeId finnes ikke", 2134, -1);
			
			/*
			 * Reads the first customer from the result set, since kunde_id it the primary key,
			 * this should always be the only one, and returns a customer object with the 
			 * atributs gotten from the database
			 */
			if (rs.next()) {
				String firstName = rs.getString("fornavn");
				String surName = rs.getString("etternavn");
				String address = rs.getString("adresse");
				String phone = rs.getString("telefon");
				int postcode = rs.getInt("postnummer");
				String town = rs.getString("poststed");
				result = new CustomerOb(firstName, surName, address, phone, town , postcode, kunde_id);
				}
			
			return result; //returns Error-customer, with kunde_id = -1
		} catch (Exception e) {
			System.out.println("lagKundeObjekt med kunde id har ftt en error!");
			return null;
		}
	}
	
	/**
	 * Changes a customers info to the new info received
	 * @param customer the CustomerOb with the new info
	 * @return 1 if something was changed, 0 if nothing was changed and -1 if you got an error
	 */
	public static int changeCustomer(CustomerOb customer){
		try {
			
			//Updates everything in the database row with the right customer Id to the info gotten from the CustomerOb
			stmt = Controller.con.createStatement();
			return stmt.executeUpdate("UPDATE kunde set fornavn= '" +  customer.getFornavn() +
					"',etternavn=' " + customer.getEtternavn() + "',adresse=' " + customer.getAdresse() + "',telefon='"
					+ customer.getTelefon() + "',postnummer=" + customer.getPostnummer() +
					", poststed='" +customer.getPoststed() + "'"   + "WHERE kunde_id= " + customer.getKundeId());
			
		} catch (Exception e) {
			PrintLine.println("feil i endreKunde");
			return -1;
		}
	}

//--------------------ANNNET-----------------
	
	/**
	 * Gets all the customers from the database and returns them in a CustomerObArray
	 * @return all the customers in a CustomerObArray
	 */
	public static CustomerOb[] getAllCustomers() {
		try  {
			ResultSet rs;
			
			//ArrayList used because we can't know the size of the ResultSet
			ArrayList <CustomerOb> customers = new ArrayList <CustomerOb>();
			CustomerOb[] result;
			stmt = Controller.con.createStatement();
			rs=stmt.executeQuery ("SELECT * FROM kunde");
			
			while (rs.next()){
				CustomerOb tempCustomer = new CustomerOb(rs.getInt("kunde_id"));
				customers.add(tempCustomer);
			}
			result = new CustomerOb[customers.size()];
			customers.toArray(result);
			return result;
		}
		
		catch(SQLException e){
			PrintLine.println("SQL ERROR, har du husket  skru p databasenforbindelsen?");
			return null;
		}
		catch(Exception e) {
			System.out.println("Error i hentAlleKunder");
			return null;
		}
	}

	/**
	 * Adds a new customer in the database
	 * @param firstName The first name of the customer
	 * @param surName Last name of the customer
	 * @param address Address of the customer
	 * @param phone Phone number of the customer
	 * @param postcode postal code(zip code) of the customer
	 */
	public static int addCustomer(String firstName, String surName, String address, String phone, int postcode, String poststed){
		ResultSet rs;
		//firstName and surName must be something else a error is return(-1), should not happend
		if (firstName == null || surName == null){
			return -1;
		}
		//If one of the other attributes are null it makes them " ", to simplify the insertion process
		if (address == null){
			address = " ";
		}
		if (phone == null){
			phone = " ";
		}
		//postnummer is an int, so we check if it is 0 and setts it as 0000(could be omitted)
		if (postcode == 0){
			postcode = 0000;
		}
		try{
			//adds the new customer in the database
			stmt = Controller.con.createStatement();
			stmt.executeUpdate("INSERT INTO kunde (fornavn, etternavn," +
					" adresse, telefon, postnummer, poststed)VALUES ('" + firstName + "','" + surName + "','"
					+ address + "','" + phone + "'," + postcode + ",'" + poststed + "')");
			
			/*
			 * Gets the same customer to find the customer Id (if to customers are identical it gives the kunde_id of the first one,
			 * But that should not be a problem, as if they are identical it doesn't matter which one you use
			 */
			stmt = Controller.con.createStatement();
			rs = stmt.executeQuery("SELECT * FROM kunde WHERE fornavn = '" + firstName +
					"'AND etternavn ='" +  surName + "'AND adresse ='" + 
					address + "'AND postnummer=" + postcode);
			rs.next();
			return rs.getInt("kunde_id");
			
		}catch (SQLException e){
			PrintLine.println("har du husket  starte databasen?");
			return -1;
		}catch (Exception e) {
			PrintLine.println("noe er feil i leggTilKunde, returnerer -1");
			return -1;
		}
		
	}

	//-----------------------Test --------------------------//
	
	/**
	 * Empty the database, for testing
	 */
	public static void dropTable() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
		stmt = Controller.con.createStatement();
		stmt.executeUpdate("DELETE FROM matbestilling" );
		stmt.executeUpdate("DELETE FROM matrett" );
		stmt.executeUpdate("DELETE FROM bestilling" );
		stmt.executeUpdate("DELETE FROM kunde" );	
	}

}
