package no.ntnu.it1901.resturant.database;
import java.sql.*;
import java.util.ArrayList;

import no.ntnu.it1901.resturant.Objecter.DishOb;
import no.ntnu.it1901.resturant.controller.Controller;
import no.ntnu.it1901.resturant.other.PrintLine;

/**
 * Contains methods for accessing the Matrett table in the database
 * 
 * @author Arnfinn
 * @author Glover
 * @version 1.9 15.11.2010
 */
public class Dish {
	private static Statement stmt;
		
	/**
	 * Makes a dish object from the database
	 * 
	 * @param rett_id the id of the dish
	 */
	public static DishOb createDish(int rett_id)  {
		try {
			ResultSet rs;
			stmt = Controller.con.createStatement();
			//Henter ut en matrett utifra rett_id(primrnkkel)
			rs = stmt.executeQuery("SELECT * FROM matrett WHERE rett_id = " + rett_id);
			rs.next();
			//Returnerer et matrettOb Object
			return  new DishOb(rs.getDouble("pris"),rs.getString("rettnavn"),rs.getString("kommentar"), rett_id);
			}
		catch (Exception e){
				PrintLine.println("Error i lagMatrett");
				return null;
		}
		
	}
	
	/**
	 * leggTilMatrett adds a new dish in the database
	 * 
	 * @param price the price of the dish
	 * @param dishName the name of the dish
	 * @param comment the comment of the dish(if any)
	 */
	public static int addDish(double price, String dishName, String comment){
		ResultSet rs;
		try {
			stmt = Controller.con.createStatement();
		
			stmt.executeUpdate ("INSERT INTO matrett (pris, rettnavn, kommentar)VALUES ("  
					+ price + ",'" + dishName + "',' " + comment + "')");
			
			//Retrieve the same dish to return the id
			Statement stmt = Controller.con.createStatement();
			
			rs = stmt.executeQuery("SELECT * FROM matrett WHERE rettnavn = '" + dishName + "' AND pris = "+ price);
			rs.next();
			return rs.getInt("rett_id");
			
		} catch (Exception e){
			PrintLine.println("Error i LeggTilMatrett");
			return -1;
		}
	}
	/**
	 * gets the name of a dish from its ID
	 * 
	 * @param rettid
	 * @return A String with the name of the dish
	 */
	public static String finnRettNavn(int rettid){
		try{
			ResultSet rs;
			String result = "";
			stmt = Controller.con.createStatement();
			rs = stmt.executeQuery("SELECT * FROM matrett WHERE rett_id = " + rettid);
			if(rs.next()){
				result = rs.getString("rettnavn");
			}
			return result;
		}
		catch(Exception e){
			PrintLine.println("Error i finnRettNavn");
			return "error//fant ikke matrett";
		}
	}
	
	/**
	 * Changes the comment of a dish in the database
	 * 
	 * @param comment The comment that you are to add
	 * @param dishId which dish to add the comment to
	 */
	
	public static void changeComment(String comment, int dishId){
		//Makes a SQL statement to update the comment in the database(or create one if it does not exist)
		try{
			stmt = Controller.con.createStatement();
			stmt.executeUpdate ("UPDATE matrett SET kommentar= '" + comment + "' " +
				"WHERE rett_id=" + dishId);
		} catch (Exception e) {
			PrintLine.println("Error i endreKommentar");
		}
	}
	
	/**
	 * Gets all the dishes in the database and returns them as a DishOb array
	 * 
	 * @return DishOb[] all the dishes from the database
	 */
	public static DishOb[] getMenu(){
		ResultSet rs;
		ArrayList <Integer>temp = new ArrayList<Integer>();
		DishOb [] result;
		try {
			stmt = Controller.con.createStatement();
			rs=stmt.executeQuery("SELECT * FROM matrett" );
			
			//gets all the dishIds
			while(rs.next()){
				temp.add(rs.getInt(1));
			}
			
			result = new DishOb [temp.size()];
			
			//creates dishes from all of them
			for (int i = 0; i < temp.size(); i++){
				result[i] = createDish(temp.get(i));
			}
			
			//Sort the results before returning them
			result = DishOb.sort(result);		
			return result;
		} catch (Exception e) {
			PrintLine.println("Error in getMeny");
			return null;
		}
	}

	/**
	 * Deletes a Dish from the database
	 * 
	 * @param rett_id The dish that are to be deleted
	 * @return int 1 if something was deleted, 0 if nothing was deleted(the Dish did not exist) and -1 if there was an error
	 */
	public static int deleteDish(int rett_id){
		try {
			stmt = Controller.con.createStatement();
			return stmt.executeUpdate("DELETE FROM matrett WHERE rett_id=" + rett_id );
			
		} catch (Exception e) {
			PrintLine.println("Error i slettMatrett");
			return -1;
		}
	}
	
}

