package no.ntnu.it1901.resturant.database;
import java.sql.*;
import java.util.ArrayList;

import no.ntnu.it1901.resturant.Objecter.OrderOb;
import no.ntnu.it1901.resturant.Objecter.CustomerOb;
import no.ntnu.it1901.resturant.controller.Controller;

/**
 * Contains methods for adding and changing in the bestilling and matbestilling tables in the database.
 * 
 * @author Glover
 * @author Arnfinn
 * @version 1.7 12.11.2010
 */


public class Order {

	private static Statement stmt;
	
	/**
	 * Returns to  all the undelivered orders.
	 * 
	 * @return a Object array with all the created but undelivered orders.
	 *  The Object array contains OrderOb,
	 *  and the connected CustomerOb on the same line.
	 */
	public static Object[][] getUleverteBestillinger(){
		try{
			ResultSet rs, rs1;
			int mat[];
			
			/*
			 * Henter ut relevant data i arraylister
			 * (KundeId, bestillingsId, dato og kommentar)
			 * Dato hentes som en String p grunn av problemer med 
			 * konverteringen fra derbyTimestamp til JavaTimestamp og SQLTimestamp
			 */
			ArrayList<Integer> bestillingsID = new ArrayList<Integer> ();
			ArrayList<String> dato = new ArrayList<String> ();
			ArrayList<String> kommentar = new ArrayList<String> ();
			ArrayList<Integer> kundeId = new ArrayList<Integer> ();
			
			/*
			 * ID brukes for  kunne hente ut alle matretter(fra matbestiling) 
			 * fra hver bestillingsID uten  tmme bestillingsID
			 */
			Object[][] result;
			ArrayList<Integer> ID = new ArrayList<Integer> ();
			int[] tempKundeId;
			int[] tempBestillingId;
			
			// Lager SQL statement for  finne alle ikke leverte bestillnger, som s kan leveres
			stmt = Controller.con.createStatement();
			rs = stmt.executeQuery("SELECT * FROM bestilling WHERE utfort = 1 AND levert = 0 AND skal_leveres = 1");
			
			while (rs.next())   {
				kundeId.add(rs.getInt("kunde_id"));
				bestillingsID.add(rs.getInt("bestillings_id"));
				dato.add(rs.getTimestamp("dato").toString());
				kommentar.add(rs.getString("kommentar"));
			}
			result = new Object[bestillingsID.size()][2];
			tempBestillingId = new int[bestillingsID.size()];
			tempKundeId = new int[bestillingsID.size()];
			
			// Henter ut alle matretter i hver bestilling
			for (int i = 0; i < result.length ; i++){
				stmt = Controller.con.createStatement();
				tempBestillingId[i] = bestillingsID.remove(0);
				rs1 = stmt.executeQuery("Select * FROM matbestilling WHERE bestillings_id ="
						+ tempBestillingId[i] );
				while(rs1.next()){
					ID.add(rs1.getInt("rett_id"));
				}
				
				// Legger alle matrettId i en array, da construktoren(bestillingOb) vil ha det
				mat = new int [ID.size()];
				for (int j = 0; j < mat.length; j++){
					mat[j] = ID.remove(0);
						}
				tempKundeId[i] = kundeId.remove(0);
				System.out.println(tempKundeId[i]);
				
				// Lager et kundeobject fra kundeid
				result[i][1] = Customer.createCustomerObject(tempKundeId[i]);
				
				// Lager et bestillings objekt utifra data den har hentet.
				result[i][0] = new OrderOb(tempBestillingId[i],tempKundeId[i], dato.remove(0),mat,0,0,kommentar.remove(0));
				}
			return result;
		}
		catch (Exception e){
			System.err.println("error i getUleverteBestillinger");
			return null;
		}
		
		
		
	}
	
	/**
	 * Returns all unfinished/uncreated orders.
	 * 
	 * @return a array of all the unfinished orders in the database
	 */
	
	public static OrderOb[] getUferdigBestillinger(){
		try{
			ResultSet rs, rs1;
			
			// Lager SQL statement for  finne alle uferdige bestillnger, som kokken s kan lage
			stmt = Controller.con.createStatement();
			rs = stmt.executeQuery("SELECT * FROM bestilling WHERE utfort = 0");
			
			/*
			 * Henter ut relevant data i arraylister(bestillingsId, dato og kommentar)
			 * Dato hentes som en String p grunn av problemer med 
			 * konverteringen fra derbyTimestamp til JavaTimestamp og SQLTimestamp
			 */
			
			ArrayList<Integer> bestillingsID = new ArrayList<Integer> ();
			ArrayList<String> dato = new ArrayList<String> ();
			ArrayList<String> kommentar = new ArrayList<String> ();
			ArrayList<Integer> kundeId = new ArrayList<Integer> ();
			
			while (rs.next())   {
				kundeId.add(rs.getInt("kunde_id"));
				bestillingsID.add(rs.getInt("bestillings_id"));
				dato.add(rs.getTimestamp("dato").toString());
				kommentar.add(rs.getString("kommentar"));
			}
			
			/*
			 * ID brukes for  kunne hente ut alle matretter(fra matbestiling) 
			 * fra hver bestillingsID uten  tmme bestillingsID
			 */
			OrderOb[] result = new OrderOb[bestillingsID.size()];
			ArrayList<Integer> ID = new ArrayList<Integer> ();

			
			//Henter ut alle matretter i hver bestilling
			for (int i = 0; i < result.length ; i++){
				stmt = Controller.con.createStatement();
				rs1 = stmt.executeQuery("Select * FROM matbestilling WHERE bestillings_id =" + bestillingsID.get(0));
				while(rs1.next()){
					ID.add(rs1.getInt("rett_id"));
				}
			
				//legger alle matrettId i en array, da construktoren(bestillingOb) vil ha det
				int mat[] = new int [ID.size()];
				for (int j = 0; j < mat.length; j++){
					mat[j] = ID.remove(0);
						}
				
				//lager et bestillings objekt utifra data den har hentet.
				result[i]= new OrderOb(bestillingsID.remove(0), kundeId.remove(0), dato.remove(0), mat, 0, 0, kommentar.remove(0));
				
				}
			return result;
		}
		catch (Exception e){
			System.err.println("error i getUferdigeBestillinger");
			return null;
		}
	}
	
	/** 
	 * Changes the databse entry of the order with the id of the Parameter.
	 * 
	 * @param  bestillingId order id of the order you with to sett as deliverd.
	 */
	public static void settLevertBestilling(int bestillingId){

		try{
			// lager SQL statement for  bytte status p en bestiling til ferdig utfrt(kokken har laget den)
			stmt = Controller.con.createStatement();
			stmt.executeUpdate ("UPDATE bestilling SET levert= 1 WHERE bestillings_id=" + bestillingId);
			stmt = Controller.con.createStatement();
			
		}
		catch (Exception e){
			 System.err.println("Error i settLevertBestilling");
		}
		
	}	
	/**
	 * Changes the entry of the order with bestillings_id(Parameter)
	 * in the database such that it is sett as created/made.
	 * 
	 * @param bestillingId order id of the order you wish to be sett as made.
	 */
	public static void settFerdigBestilling(int bestillingId){

		try{
			// lager SQL statement for  bytte status p en bestiling til levert
			stmt = Controller.con.createStatement();
			stmt.executeUpdate ("UPDATE bestilling SET utfort= 1 WHERE bestillings_id=" + bestillingId);
			
		}
		catch (Exception e){
			 System.err.println("Error i settFerdigBestilling");			 
		}
		
	}
	/**
	 * Changes the komment of the entry with id of the second parameter.
	 * 
	 * @param kommentar comment you wish to change to.
	 * @param bestillingId order id to the order you wish to change.
	 */
	
	public static void settDatabaseKomment(String kommentar, int bestillingId) {
		try{
			//Lager SQL statement for  sette/update kommentaren til en bestilling
			stmt = Controller.con.createStatement();
			stmt.executeUpdate ("UPDATE bestilling SET kommentar= '" + kommentar+ "' WHERE bestillings_id=" + bestillingId);
			
		}
		catch (Exception e){
			 System.err.println("error i settDatabaseKomment");
		}
		
	}


	/**
	 * Makes a new entry in the database.
	 * @param kundeId
	 * @param matretter array
	 * @param kommentar
	 * @param skal_leveres
	 * @return true, if the creating was succsessfull.
	 */
	public static boolean leggTilBestilling(int kundeId, int[] matretter, String kommentar, int skal_leveres){
		try{
			if (matretter.length == 0){
				return false;
			}
			ResultSet rs;
			boolean result = false;
			
			// Legger til bestillinger, men n ogs med en kommentar
			stmt = Controller.con.createStatement();
			/*
			 * Henter systemtiden for  legge til denne i databasen
			 * og ogs bruke den til  finne igjen bestillingen nr vi bruker bestillings_id for
			 *  legge til matbestillingsobjekter 
			 */
			long tid = System.currentTimeMillis();
			java.sql.Timestamp dato = new Timestamp(tid);			
			if( stmt.executeUpdate("INSERT INTO bestilling (utfort, levert," +
					"skal_leveres, kunde_id, dato, kommentar)VALUES (0,0," + skal_leveres + ","
					+  kundeId + ",'" +  dato + "','" + kommentar +"')")==1){
				result = true;
			}
			
			//lager statement for  finne igjen bestillingen vi nettopp la til
			stmt = Controller.con.createStatement();
			rs = stmt.executeQuery("SELECT bestillings_id FROM bestilling WHERE dato = '" + dato +"'");
			rs.next();
			int bestillingsId = rs.getInt("bestillings_id"); 
			
			/*
			 * Legger til en matbestilling for hver rett i bestillingen(med forskjellig rettid, selvflgelig)
			 * og henter ut prisen
			 */
			for (int i = 0; i < matretter.length; i++) {
				stmt = Controller.con.createStatement();
				stmt.executeUpdate("INSERT INTO matbestilling(bestillings_id, rett_id)" +
						" VALUES (" + bestillingsId + "," + matretter[i] + ")");
			}
			return result;
		}
		catch (Exception e) {
			System.err.println("Error i leggTilBestilling");
			return false;
		}
		
		}
	
	 

}
