package no.ntnu.it1901.resturant.other;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;

/**
 * Printer example used and expanded on from
 * http://www.java-tips.org/java-se-tips/java.awt.print/simplest
 * -print-example.html
 */
public class TextPrinter implements Printable {
	 private static final int LEFT_MARGIN = 36;

	/**
	 * Initiates a print job with the given text<br>
	 * It will split the string by "\n" in the document
	 */

	String output;

	public TextPrinter(String outputToPrinter) {

		output = outputToPrinter;

		//Create a printerJob object
		PrinterJob printJob = PrinterJob.getPrinterJob();

		/*
		 * Set the printable class to this one since we
		 * re implementing the Printable interface
		 */
		printJob.setPrintable(this);

		/*
		 * Show a print dialog to the user. If the user
		 * click the print button, then print otherwise
		 *cancel the print job
		 */
		if (printJob.printDialog()) {
			try {
				printJob.print();
			} catch (Exception PrintException) {
				PrintException.printStackTrace();
			}
		}

	}

	/**
	 * 
	 * Splits the output String in lines and create them one by one.
	 * 
	 * It will only print the first page.
	 * 
	 * @param g
	 *            a value of type Graphics
	 * @param pageFormat
	 *            a value of type PageFormat
	 * @param page
	 *            a value of type int
	 * @return a value of type int
	 */
	public int print(Graphics g, PageFormat pageFormat, int page) {
	
		Graphics2D g2d;

		//Validate the page number, we only print the first page
		if (page == 0) { //Create a graphic2D object a set the default parameters
			g2d = (Graphics2D) g;
			g2d.setColor(Color.black);

			//Translate the origin to be (0,0)
			g2d.translate(pageFormat.getImageableX(), pageFormat
					.getImageableY());

			String lines[] = output.split("\n");
			for (int j = 0; j < lines.length; j++) {
				g2d.drawString(lines[j], LEFT_MARGIN, (j + 2) * 20);

			}

			return (PAGE_EXISTS);
		} else
			return (NO_SUCH_PAGE);
	}

}
