package credit;

public final class CreditSpreadPoint {
	private final double rate;

	private final double maturity;

	private final CreditSpreadType spreadType;

	public CreditSpreadPoint() {
		this(0, 0, CreditSpreadType.Relative);
	}

	public CreditSpreadPoint(double rate, double maturity,
			CreditSpreadType spreadType) {
		this.rate = rate;
		this.maturity = maturity;
		this.spreadType = spreadType;
	}
	
	public CreditSpreadPoint(CreditSpreadPoint csp) {
		this(csp.getRate(), csp.getMaturity(), csp.getSpreadType());
	}

	public CreditSpreadType getSpreadType() {
		return spreadType;
	}

	public double getMaturity() {
		return maturity;
	}

	public double getRate() {
		return rate;
	}
}
