package tests;

import junit.framework.TestCase;
import rates.SwapCashFlows;
import rates.SwapLeg;
import rates.YieldCurve;

import common.Date;
import common.TimeUnit;

public class VanillaSwapTest extends TestCase {

	private YieldCurve testCurve;

	private Date[] dates;

	private double[] notionals;

	SwapLeg swapLeg;

	SwapCashFlows fixedLeg;

	SwapCashFlows floatingLeg;

	public void setUp() throws Exception {
		super.setUp();
		setUp5YAnnualVanillaSwap();
	}

	private void setUp5YAnnualVanillaSwap() {
		testCurve = new YieldCurve(0.05);
		dates = new Date[5];
		notionals = new double[5];
		for (int i = 0; i < 5; i++) {
			dates[i] = Date.setDateToToday();
			dates[i] = dates[i].advance(i + 1, TimeUnit.Years);
			notionals[i] = 1000000;
		}
		swapLeg = new SwapLeg(dates, notionals);
		fixedLeg = new SwapCashFlows(swapLeg, 0.05);
		floatingLeg = new SwapCashFlows(swapLeg, testCurve);
	}

	public void test5YAnnualVanillaSwapLegValuesAndPrice() {
		double swapPrice = fixedLeg.getFairValue(testCurve)
				- floatingLeg.getFairValue(testCurve);
		boolean result = swapPrice > -0.000001 && swapPrice < 0.000001;
		assertTrue(result);
	}
}
