package chat;


import java.util.*;


/**
 * A class representing a digital persona known as a chat bot. 
 * The chat bot can start conversations and reply to remarks. 
 * <p> Used in AIJP assignments 1 and 2.</p>
 * 
 * @author Judy Robertson
 */
public class ChatBot {

    /**
     * The name of the character
     */
   
    private ArrayList <SentenceTemplate> sentenceList= new ArrayList <SentenceTemplate> ();
    private Random randomGenerator;
    private HashMap<String, String> remarkMap;

   
    private String Sentence;

    /**
     * Create a ChatBot, initialise the language generator
     * This creates an instance of TemplateLanguageGenerator to create and reply to sentences.
     */

    public ChatBot() {
        randomGenerator= new Random();
        remarkMap= new HashMap<String, String>();
        populateSentences();
        fillRemark();

    }

 

    /**
     * Generates a response to the specified remark
     * 
     * @param remark The comment which must be responded to
     * 
     * @return A sentence which represents a reply to the specified remark
     */
    

    public String generateSentence() {
    int randomIndex; 
    String sentenceGen="";
    String templateGen="";
    String templateType="";
    boolean questionFound=true;
    while(questionFound)
    {
    randomIndex=randomGenerator.nextInt(sentenceList.size());
    templateType=sentenceList.get(randomIndex).getSentenceType(); 
    if (templateType.equals("question")){
        templateGen=sentenceList.get(randomIndex).getTemplate();

        return templateGen;
    }
    }
    return "What is a %NOUN%?"; //returns this default question template if questionFound is set to False
    }
    
    
    
    
    private void populateSentences() {
        sentenceList.add(new SentenceTemplate("question","You can not shoot me agent Niro, I was sent to help you"));
        sentenceList.add(new SentenceTemplate("question","how are you Agent? I am here to help."));
        sentenceList.add(new SentenceTemplate("question","I know you are innocent. I will help you escape"));
        sentenceList.add(new SentenceTemplate("reply","The cafeteria in the north is a dead-end"));
        sentenceList.add(new SentenceTemplate("question","The time machine? It is kept in the Armour room. You must pick it up"));
        sentenceList.add(new SentenceTemplate("reply","The guards will shoot if you don't have a gun"));       
        sentenceList.add(new SentenceTemplate("reply","From the armour room you must go NORTH to escape"));  
        sentenceList.add(new SentenceTemplate("question","From the cafeteria go west"));
        
    }
        
        private void fillRemark(){       
        remarkMap.put("exit", "I am aware of it. But I personally think that %NOUN% is %ADJECTIVE%");
        remarkMap.put("time", "you must find the time machine soon");
        remarkMap.put("alcatraz", "Yes, this prison is heavily guarded");
        remarkMap.put("cafeteria", "Thats true. It is also very %ADJECTIVE%");
        remarkMap.put("fond", "Is it so? Is it as good as %NOUN%?");
        remarkMap.put("machine", "Yes, you must find the time machine to escape");
        remarkMap.put("secret", "Yes, I work for the IRA division D");
        remarkMap.put("default","I'm sorry I don't understand you"); 
     
    }
        
    
    
        /** This method is used to implement the keyword found by using a random template found with a synonym 
 * of the keyword noun.
 * 
 * Here counter is used to replace only the first occurence of NOUN with a synonym and others with 
 * any random NOUN.
 */    
    
   
        
        

       

}
