
package game; 
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import chat.ChatBot;
/**
 *  This class is part of the "Escape from Alcatraz" application. It is an adventure game with buttons and room images.
 * 
 *  This class creates all rooms,characters and items for running the game.
 * 
 * 
 *  the successful completion of the game involves the user to find the time machine( item=watch) and not get killed by any guards and
 * reach the exit room roo013.
 * 
 * A player gets killed if he enters a room with a guard when the player does not carry a gun or has not picked up a gun. If the player reaches the 
 * exit without the watch he is asked to return to the maze and find the watch.
 *  
 * 
 * @author  Michael Kolling and David J. Barnes
 * @version 1.0 (Jan 2003)
 */
public class GameEngine
{
    private Parser parser;              //an instance to the parser class
    private static Room currentRoom;    //the current room instance. Since there can only be one instance created
    private static UserInterface gui;   //interface is also made static since we require only one instance
    private ChatBot chatBot;            //in chatbot only a generate sentence method is used to generate random sentences 
                                        //chatbot is a property of this class since it has a list of sentences that are not specific
                                        // to any character. All characters speak random goal related sentences.
    private Item gun;                   // these are the items and the characters  in this game.
    private Item watch;
    private Character niro;
    private Character liz;
    private Character nithin;
    private Character guard1;
    private Character guard2;
    private Character guard3;
    private Character guard4;   
    private ArrayList<Character> aliveBadGuys;  //if a character is bad then he is put into this array. 
                                                //Niro can shoot only the bad guys.
    
    /**
     * this is the constructor for Game Engine. IT does all the initializations that are required before starting the program
     */
    public GameEngine()
    {   
        parser = new Parser(); //Parser is used to integrate commmands and command words
        createItems();          //creates instances of the items used in this game
        createCharacters();     //creates instances of characters used in this game
        createRooms();          //creates room instances and adds characters and items into the rooms
        System.out.println(currentRoom.getRoomImageTitle()); //shows the current room in the terminal. used for checking the program at run time
        chatBot=new ChatBot();
    }

   
    /**
     * sets up the GUI for the Game Engine.
     * @param userInterface
     */
    public void setGUI(UserInterface userInterface)
    {
        gui = userInterface;
    }


    /**
     * Create all the rooms and link their exits together.
     */
    private void createCharacters(){
        niro = new Character("nithin", "Niro.. thats you...",false);
        liz= new Character("liz","Liz is a security guard who can help",false);
        nithin = new Character("nithin","Xinghua is a convict who is looking for an escape route",false);
        guard1= new Character("guard1","Security Guard with Gun.. ",true);
        guard1.setitemforCharacter(gun);
        guard2= new Character("guard2","Jail Warden Armed with a gun.. ",true);
        guard2.setitemforCharacter(gun);
        guard3= new Character("guard3","Prison Guard will raise an alarm if he sees you.. ",true);
        guard3.setitemforCharacter(gun);
        guard4= new Character("guard4","Prison Guard will raise an alarm if he sees you.. ",true);  
        guard4.setitemforCharacter(gun);
        aliveBadGuys = new ArrayList<Character>();
        
        aliveBadGuys.add(guard1);           //this is an arraylist of the bad guys in the game. Niro, our hero in this game can shoot only
                                            // if the character is a bad guy. otherwise a message is displayed
        aliveBadGuys.add(guard2);
        aliveBadGuys.add(guard3);
        aliveBadGuys.add(guard4);
    }
    
    
    /**
     * creates instances of the items that are used in this game
     */
    private void createItems(){
        gun= new Item("gun","Machine gun AK47");    
        watch= new Item("watch","This is the time machine.. it can transport you back to AD2008.");
    }
    
    /**
     * creates instances of the rooms and sets their exits, the items in a room and the characters in the room.
     * A character can pick up any number of items and a room can contain only one item. 
     * 
     */
    private void createRooms()
    {
        Room r01PrisonCells, r02Execution,r03Guard,
                r04Security,r05Surveilance,r06Detention,r07PrisonCells,
                r08PrisonCells,r09Xinghua,r10HighSecurity,r11Armour,
                r12Courtyard,r13Exit, r14Cafeteria;
      
        // create the rooms
        r01PrisonCells = new Room("r01","outside your Prison Cell. You are standing in the corridor");
        r02Execution = new Room("r02","in the Exection room where prisoners are executed");
        r02Execution.setItem(gun);
        r03Guard = new Room("r03","in the Prison Guards Office");
        r04Security = new Room("r04","in the high security area. Beware of guards");
        r04Security.setCharacter(guard1);
        r05Surveilance=new Room("r05","in the suiveilance room");
        r06Detention=new Room("r06","in the detention room");
        r06Detention.setCharacter(liz);
        r07PrisonCells = new Room("r07","in the room full of prison cells");
        r07PrisonCells.setCharacter(guard2);
        r08PrisonCells = new Room("r08","in a corridor with prison cells on both sides");
        r09Xinghua= new Room("r09","in a dark room with a small light bulb");
        r09Xinghua.setCharacter(nithin);
        r10HighSecurity = new Room("r10","in the high security room. Beware of armed guards");
        r11Armour = new Room("r11","in the Armour room. The storage place for guns");
        r11Armour.setCharacter(guard3);
        r11Armour.setItem(watch);
        r12Courtyard = new Room("r12","in the Courtyard. High security area");
        r12Courtyard.setCharacter(guard4);
        r13Exit= new Room("r13","in the front yard that leads to the exit");
        r14Cafeteria = new Room("r14","in the cafeteria, there should be food here");
        
        // initialise room exits
        r01PrisonCells.setExit("north", r02Execution);
        
        r02Execution.setExit("south", r01PrisonCells);
        r02Execution.setExit("north", r03Guard);
        r02Execution.setExit("west", r06Detention);
        
        r03Guard.setExit("south", r02Execution);

        r04Security.setExit("north", r05Surveilance);
        
        r05Surveilance.setExit("north", r06Detention);
        r05Surveilance.setExit("south", r04Security);
        r05Surveilance.setExit("west", r09Xinghua);        

        r06Detention.setExit("north", r07PrisonCells);
        r06Detention.setExit("east", r02Execution);
        r06Detention.setExit("south", r05Surveilance);

        
        r07PrisonCells.setExit("south", r06Detention);
        r07PrisonCells.setExit("west", r14Cafeteria);
        
        r08PrisonCells.setExit("north", r14Cafeteria);
        r08PrisonCells.setExit("south", r09Xinghua);
        
        r09Xinghua.setExit("west", r11Armour);
        r09Xinghua.setExit("north", r08PrisonCells);
        r09Xinghua.setExit("east", r05Surveilance);
        
        r10HighSecurity.setExit("north", r13Exit);
        r10HighSecurity.setExit("south", r11Armour);

        r11Armour.setExit("north", r10HighSecurity);
        r11Armour.setExit("east", r09Xinghua);
        r11Armour.setExit("west", r12Courtyard);
        
        r12Courtyard.setExit("east",r11Armour);
     
        r13Exit.setExit("south", r10HighSecurity);
        r14Cafeteria.setExit("south", r08PrisonCells);
        r14Cafeteria.setExit("east", r07PrisonCells);
        
        
  //the current room is initialized to the Prison Cell room r01.      
        currentRoom = r01PrisonCells;  // start game from this room    
    }

    
    /**
     * returns the current Room path to the image file.
     * @return - String with the path to the image file
     */
    public String getCurrentRoom()
    {
        return currentRoom.getRoomImageTitle();
    }

    /**
     * the commandwords are represented by buttons which are interpreted here. Pressing a command button generates a commandword
     * and that triggers a method call here. 
     */
    public void interpretCommand(String commandLine) 
    {
        System.out.println(commandLine);    //for debugging the code
        Command command = parser.getCommand(commandLine); //parser generated a command. it would not be necessary in a button based game. but 
                                                            // it is retained for extending the game later on

        if(command.isUnknown()) {
            gui.println("I don't know what you mean...");
            return;
        }

        String commandWord = command.getCommandWord();
        if (commandWord.equals("help"))
            printHelp();
     
        else if (commandWord.equals("shoot"))
            shootBadGuy();
        
        else if (commandWord.equals("talk"))
            startConversation();

        else if (commandWord.equals("go"))
            goRoom(command);
        
        else if (commandWord.equals("pick"))
            take();
        else if (commandWord.equals("quit")) {
           
                endGame(true);
        }
    }

    // implementations of user commands:

    /**
     * Print out some help information.
     * gives information on the current location of the room and its exits.
     */

    private void printHelp() 
    {
        gui.println(
                currentRoom.getLongDescription());
    }
    
   
   /**
    * this is used to test if the hero of the game.. (which is the player) has a gun or not. if he does not have a  gun and he 
    * encounters a guard or security he will die.  these are implemented in order to avoid null pointer errors.
    * @return true if he has a gun and galse if he does not.
    */ 
    public boolean doesHeroHaveGun()
    {ArrayList newArray=niro.getItemList();
     if (newArray.contains(gun)){
         return true;
         
     } else{
         return false;
     }
    }
    
    /**
     * the successful end condition of the game is that the player must enter room013 exit with the time machine (item=watch)
     * thisis used to check that. these are implemented in order to avoid null pointer errors.
     * @return boolean true/false
     */
    public boolean doesHeroHaveWatch(){
     ArrayList newArray=niro.getItemList();
     if (newArray.contains(watch)){
         return true;
         
     }  else
     {
         return false;
     }
    } 
    
    
    /**
     * the user can take items from the room using this method. The item from the current room is deleted and the item
     * is added to the array list of items that is associated with the player.
     */
    private void take(){
        if(currentRoom.isItemPresent())     //checks if there is an item in the room
        {
        gui.updateItemInfo("you have taken the " + currentRoom.getRoomItemImage()); //updated gui
        niro.setitemforCharacter(currentRoom.getItem());        //adds item to the character instance
        currentRoom.deleteItem();               //deleted item from the room so that it is not displayed when the player reenters the room
        gui.updateItemPanel("no other items in this room");     //updated room item status
        }
        else
        {
            gui.updateItemInfo("There are no ITEMS for you to take from here"); //informs the user that there are no items in the room
        }
    }
    
    
    /**
     * this is used to generate a string of speech from the character. it is associated with the game engine itself since the
     * characters do not have specific dialogues. They speak the random sentenes that are got from templates.
     * 
     * only this function of chatbot is implemented here
     * 
     */
    private void startConversation()
            
    {  
       
      System.out.println(chatBot.generateSentence()); 
       gui.updateConvesation(currentRoom.getRoomCharacterImage()+" says: "+ chatBot.generateSentence()); 
       
    }
    
   
    /**
     * this is used to get a room instance.
     * @return returns the current room object
     */
    public Room roomPresent(){
        return currentRoom;
    }
    
    
    /**
     * only the bad guys can be shot. so the method checks if there is a character in the room, 
     * then it checks if the character is a bad guy and then executes shoot and deleted the object of the badGuy.
     * 
     * alterntively we could set the shoot button to set visible(false) but this would emulatae the real world situation better.
     */
    public void shootBadGuy(){
        if(currentRoom.isCharacterPresent())
        {  
                if (isAliveBadGuy())
            {   gui.shootSuccess();
                    gui.updateCharacterPanel("dead");
                aliveBadGuys.remove(currentRoom.getCharacter());
                currentRoom.deleteCharacter();                
            }
        else{
            gui.println("You can not shoot this person...!");
            }  
        
        }
     else {
            gui.println("There is no one to shoot.. !");
        }
    }
    
    
    /**
     * method to find if the badbuy is alive or not. this is again used to avoid any null pointer errors.
     * @return boolean true/false if bad guy is alive.
     */
    public boolean isAliveBadGuy(){
        Iterator<Character> it = aliveBadGuys.iterator();
        while (it.hasNext()) {
        if( currentRoom.getRoomCharacterImage().equals(it.next().getCharacterImage()))
        {
            return true;
        }
        
        }
        return false;
    }
    
    
    
    /** 
     * Try to go to one direction. If there is an exit, enter the new
     * room, otherwise print an error message. also updates the room GUI with information on the new room
     */
    private void goRoom(Command command) 
    {
        if(!command.hasSecondWord()) {
            // if there is no second word, we don't know where to go...
            gui.println("Go where?");
            return;
        }

        String direction = command.getSecondWord();

        // Try to leave current room.
        Room nextRoom = currentRoom.getExit(direction);

        if (nextRoom == null)
            gui.println("There is no door!");       //if there is no door it displays that there is no exit
        else {
            gui.doorSuccess();
            currentRoom = nextRoom;                 //nextroom object is set to the current room
            
            System.out.println(currentRoom.getRoomImageTitle());        //updates the GUI with the new currentRoom details
            gui.setCurrentRoomPath(currentRoom.getRoomImageTitle());
            gui.updateCommandPanel();
            gui.println(currentRoom.getLongDescription());
            if (currentRoom.isCharacterPresent())                       //updates GUI with new character details
            {   
                System.out.println(currentRoom.getRoomCharacterImage());
                gui.updateCharacterPanel(currentRoom.getRoomCharacterImage());
                
                if((currentRoom.getCharacter().isBadGuy()))             //if the character is a badGuy and player has no gun. then its game over
                {   gui.updateTalkButton(false);
                    if     (niro.hasItem())
                    { 
                        if (!(doesHeroHaveGun()))
                        {
                            endGame(false);
                        
                        }
                    }
                    else endGame(false);
                }
                else{
                gui.updateTalkButton(true);                         //if there is a character the player can speak to. ie not a bad guy then it
                                                                    //updates the gui
                }    
                
            }
            else{               gui.updateTalkButton(false);
                                gui.updateCharacterPanel("default");
            }
            
            if (currentRoom.isItemPresent()){                       //updates the gui for items present
                                System.out.println(currentRoom.getRoomItemImage()+currentRoom.getItemDetails());
                gui.updateItemPanel(currentRoom.getRoomItemImage());
                gui.updateItemInfo(currentRoom.getItemDetails());

              
            }
            else {
                                gui.updateItemPanel("noitem");
                gui.updateItemInfo("There are no useful items in this room that you can pick up. !!");

            }
            
        }
        
        if(currentRoom.getRoomImageTitle().equals("r13") && niro.hasItem())         //checks for game over condition. Game is over if niro has
                                                                                    //the time machine and reaches room 13.
                                                                                     //alternatively the final room can be put into a variable 
                                                                                    // and intitialized to increase flexibility of the game
        {
            if(doesHeroHaveWatch()){
                 endGame(true);
            }
            else{
                gui.println("you have to go back and find the time machine.. ");
            }
        }
       
    }

    
    /**
     * returns the current room details in a string
     * @return  String with current room details
     */
    public String getCurrentRoomDetails(){

        return currentRoom.getLongDescription();
        
    }
    
    
    /**
     * end game condition. checks if the user has successfully or unsuccessfully completed the game.
     * @param B is the true or false depending on the state of game completion.
     */
    private void endGame(Boolean B)
    {
        if (B == true)
        {gui.gameOver("CONGRATULATIONS.. Mission Completed Successfully!!!","Success.jpg");
        }
        else {
            
    
            gui.gameOver("SORRY..You don't have a gun and you got shot by the guard.. Thank you for playing.. ","Failure.jpg");
            
            } 
            
    }

}
