/*
 * This is the SoundEngine class. The purpose of this class is to play wmv files for the GUI of the game. This is a 
 * simple class which uses the javax.sound.sampled.* library. 
 * 
 * 
 * This Class is taken from the BlueJ tutorial Lesson11 on using GUI. The fundamental structure of the SoundEngine is the same.
 */

package game;
import java.io.*;
import javax.sound.sampled.*;
/**
 *
 * @author priya
 */
public class SoundEngine {
    private Clip newSoundClip = null; // This is the sound clip that will be played.
    private int newSoundDuration = 0;   //Duration of the sound wmv file
    private int newSoundFrameLen = 0;   //Frame Length of the sound Clip
    
     
    /* The constructor for this Class has no parameters
     * */
    
    public SoundEngine()
    {
    }
     
    /**
     * 
     * This method is used to play the sound file. It uses loadSound to load the sound File and 
     * it uses start() to start playing the file. In this context it is used to play only wmv files.
     * 
     * @param File soundFile
     * @return boolean
     */
     
        public boolean play(File soundFile)
    {
        if(loadSound(soundFile)) {
            newSoundClip.start();
            return true;
        }
        else {
            return false;
        }
    }
    
        
        /*
         * This method is used by the Class SoundEngine to load the sound file. The sound files are
         * accessed using the library java.io
         * @params File file
         * @return boolean
         * */
    
    private boolean loadSound(File file) 
    {
        newSoundDuration = 0;
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(file);
            AudioFormat format = stream.getFormat();

            // we cannot play ALAW/ULAW, so we convert them to PCM
            //
            if ((format.getEncoding() == AudioFormat.Encoding.ULAW) ||
                (format.getEncoding() == AudioFormat.Encoding.ALAW)) 
            {
                AudioFormat tmp = new AudioFormat(
                                          AudioFormat.Encoding.PCM_SIGNED, 
                                          format.getSampleRate(),
                                          format.getSampleSizeInBits() * 2,
                                          format.getChannels(),
                                          format.getFrameSize() * 2,
                                          format.getFrameRate(),
                                          true);
                stream = AudioSystem.getAudioInputStream(tmp, stream);
                format = tmp;
            }
            DataLine.Info info = new DataLine.Info(Clip.class, 
                                           stream.getFormat(),
                                           ((int) stream.getFrameLength() *
                                           format.getFrameSize()));

            newSoundClip = (Clip) AudioSystem.getLine(info);
            newSoundClip.open(stream);
            newSoundFrameLen = (int) stream.getFrameLength();
            newSoundDuration = (int) (newSoundClip.getBufferSize() / 
                              (newSoundClip.getFormat().getFrameSize() * 
                              newSoundClip.getFormat().getFrameRate()));
            return true;
        } catch (Exception ex) {
            newSoundClip = null;
            return false;
        }
    }
}
