package net.bytebuffer.commons;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.ResultSet;

import java.util.List;
import java.util.LinkedList;

import net.bytebuffer.music.data.Song_VO;
/**
 * Abstrakte Klasse zur Datenbankanbindung und überführung der Ergebnisse in entsprechende VO.
 * 
 * @author ferdinand
 *
 */
public abstract class JDBC_DAO_Base<T>  implements DAO<T> {
	private String driverName;
	private String dbURL,dbUser,dbPassword;
	
	public JDBC_DAO_Base(String driverName, String dbURL, String dbUser, String dbPassword) {
		super();
		this.driverName = driverName;
		this.dbURL = dbURL;
		this.dbUser = dbUser;
		this.dbPassword = dbPassword;
	}
	
	public JDBC_DAO_Base(){
			this("driverName","dbURL","dbUser","dbPassword");
	}

	// Stellt die Verbindung zur SQL-DB her
	protected Connection getConnection() throws DataAccessException{
		try{
			Class.forName(driverName);
			return DriverManager.getConnection(dbURL,dbUser,dbPassword);
		}
		catch(SQLException ex){
			throw new DataAccessException("DB-Connection nicht verfuegbar.",ex);
		}
		catch(ClassNotFoundException ex){
			throw new DataAccessException("Driver "+driverName+" not found.",ex);
		}
	}
	
	// Wandelt die SQL-Ergebnisliste in ein VO um
	protected List transformSet(ResultSet rs) throws SQLException{
		List voList=new LinkedList();
		while(rs.next()){
			voList.add(map2VO(rs));
		}
		return voList;		
	}
	
	// Gibt das Erste VO aus der SQL-Ergebnisliste aus
	protected T transformSet2VO(ResultSet rs) throws SQLException{
		if (rs.next()) return map2VO(rs);
		// never reached
		return null;
	}
	
	// Wandelt eine Zeile der SQL-Ergebnisliste in ein Objekt um
	protected abstract T map2VO(ResultSet rs) throws SQLException;
	
	
	
}
