package net.bytebuffer.music.data;

import java.util.GregorianCalendar;
import java.util.List;
import java.util.ArrayList;

/**
 * 
 * Value Object
 * Speichert alle Attribute einer CD
 * Bietet keine besonderen Methoden an !
 * 
 * @author ferdinand
 *
 */
public class CD_VO {

	long id;
	String titel;
	String interpret;
	GregorianCalendar veroeffentlichung;
	String coverDatei;
	List<Song_VO> songs;
	
	public CD_VO(long id, String titel, String interpret, GregorianCalendar veroeffentlichung, String coverDatei) {
		super();
		this.id = id;
		this.titel = titel;
		this.interpret = interpret;
		this.veroeffentlichung = veroeffentlichung;
		this.coverDatei = coverDatei;
		this.songs=new ArrayList<Song_VO>();
	}	
	
	public CD_VO(long ean, String titel, String interpret, int jahr, int monat, int tag, String coverDatei) {
		this(ean,titel,interpret,new GregorianCalendar(jahr,monat,tag),coverDatei);
	}
		
	public String getCoverDatei() {
		return coverDatei;
	}

	public long getId() {
		return id;
	}

	public String getInterpret() {
		return interpret;
	}

	public List<Song_VO> getSongs() {
		return songs;
	}

	public String getTitel() {
		return titel;
	}

	public GregorianCalendar getVeroeffentlichung() {
		return veroeffentlichung;
	}

	public int getSongAnzahl(){
		return songs.size();
	}

	public Song_VO getSong(int nr){
		return songs.get(nr);
	}
	
	public void setSongs(List<Song_VO> songs){
		this.songs=songs;
	}
	
	public String toString(){
		return interpret+" "+titel+" "+veroeffentlichung+" "+id;
	}
	
}
