package net.bytebuffer.music.repository;
import net.bytebuffer.commons.DataAccessException;
import net.bytebuffer.commons.JDBC_DAO_Base;
import net.bytebuffer.music.data.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.LinkedList;

/**
 * 
 * Regelt zugriff auf die Song_VO in Datenbank
 * 
 * @author ferdinand
 *
 */
public class Song_JDBC_DAO extends JDBC_DAO_Base<Song_VO>{

	public Song_JDBC_DAO(){
		
	}
	
	public Song_JDBC_DAO(String driverName, String dbURL, String dbUser, String dbPassword){
		super(driverName,dbURL,dbUser,dbPassword);
	}
	
	protected Song_VO map2VO(ResultSet rs) throws SQLException{
		return new Song_VO(rs.getInt("id"),rs.getInt("cdid"),rs.getInt("nr"),rs.getString("titel"),rs.getInt("laenge"),rs.getString("sounddatei"));
	}
	
	public Song_VO create(Song_VO vo) throws DataAccessException{
		Connection dbc=getConnection();
		PreparedStatement ps=null;
		String sqlQuery="INSERT INTO tb_song (cdid, nr, titel, laenge, sounddatei) VALUES (?,?,?,?,?)";
		try{
			// Generierte Keys sollen verfügbar sein
			ps=dbc.prepareStatement(sqlQuery, PreparedStatement.RETURN_GENERATED_KEYS);	
			// Parameter für Query setzen
			int i=1;
			ps.setInt(i++,vo.getCdId());
			ps.setInt(i++, vo.getNr());
			ps.setString(i++, vo.getTitel());
			ps.setInt(i++, vo.getLaenge());
			ps.setString(i++, vo.getSounddatei());
			// Schreiben in DB
			ps.executeUpdate();
			// Setzen der duch die DB automatisch erzeugte Id für das Objekt
			// >> Datenbank ist für diese Persistenzbedingung zuständig (Auto_Increment)
			ResultSet rs=ps.getGeneratedKeys();
			if (rs.next()) i=rs.getInt(1);
			else throw new DataAccessException("Error executing instert "+ps);
			vo.setId(rs.getInt(1));
		}
		catch(SQLException ex){
			throw new DataAccessException("Error executing "+ps,ex);
		}
		finally{
			try{
				if (ps!=null) ps.close();	
				if (dbc!=null) dbc.close();
			}
			catch(SQLException ex){
				throw new DataAccessException("Can't close Connection.",ex);
			}
		}
		return vo;	
	}

	public void update(Song_VO vo) throws DataAccessException{
		Connection dbc=getConnection();
		PreparedStatement ps=null;
		String sqlQuery="UPDATE tb_song set cdid=?, nr=?, titel=?, laenge=?, sounddatei=? WHERE id=?";
		try{
			ps=dbc.prepareStatement(sqlQuery);	
			//Parameter für Query setzen 
			int i=1;
			ps.setInt(i++,vo.getCdId());
			ps.setInt(i++, vo.getNr());
			ps.setString(i++, vo.getTitel());
			ps.setInt(i++, vo.getLaenge());
			ps.setString(i++, vo.getSounddatei());
			ps.setInt(i++,vo.getId());
			ps.executeUpdate();
		}
		catch(SQLException ex){
			throw new DataAccessException("Error executing "+ps,ex);
		}
		finally{
			try{
				if (ps!=null) ps.close();	
				if (dbc!=null) dbc.close();
			}
			catch(SQLException ex){
				throw new DataAccessException("Can't close Connection.",ex);
			}
		}
	}
	
	public Song_VO findById(int id) throws DataAccessException{
		Connection dbc=getConnection();
		Song_VO vo;
		PreparedStatement ps=null;
		String sqlQuery="Select * from tb_song WHERE id=?";
		try{
			ps=dbc.prepareStatement(sqlQuery);	
			//Parameter für Query setzen 
			ps.setInt(1,id);
			ResultSet rs=ps.executeQuery();
			vo=transformSet2VO(rs);
		}
		catch(SQLException ex){
			throw new DataAccessException("Error executing "+ps,ex);
		}
		finally{
			try{
				if (ps!=null) ps.close();	
				if (dbc!=null) dbc.close();
			}
			catch(SQLException ex){
				throw new DataAccessException("Can't close Connection.",ex);
			}
		}
		return vo;	
	}
	
	public List<Song_VO> findAll() throws DataAccessException{
		Connection dbc=getConnection();
		List<Song_VO> vos=new LinkedList<Song_VO>();
		PreparedStatement ps=null;
		String sqlQuery="Select * from tb_song";
		try{
			ps=dbc.prepareStatement(sqlQuery);	
			ResultSet rs=ps.executeQuery();
			vos=transformSet(rs);
		}
		catch(SQLException ex){
			throw new DataAccessException("Error executing "+ps,ex);
		}
		finally{
			try{
				if (ps!=null) ps.close();	
				if (dbc!=null) dbc.close();
			}
			catch(SQLException ex){
				throw new DataAccessException("Can't close Connection.",ex);
			}
		}
		return vos;	
	}
	
	public List<Song_VO> findByTitle(String titel) throws DataAccessException{
		Connection dbc=getConnection();
		List<Song_VO> vos=new LinkedList<Song_VO>();
		PreparedStatement ps=null;
		String sqlQuery="Select * From tb_Song WHERE titel LIKE ?";
		try{
			ps=dbc.prepareStatement(sqlQuery);
			ps.setString(1,titel);
			ResultSet rs=ps.executeQuery();
			vos=transformSet(rs);			
		}
		catch(SQLException ex){
			throw new DataAccessException("Error executing "+ps,ex);
		}
		finally{
			try{
				if (ps!=null) ps.close();	
				if (dbc!=null) dbc.close();
			}
			catch(SQLException ex){
				throw new DataAccessException("Can't close Connection.",ex);
			}
		}
		return vos;
		
	}

	
}
