package manager;
import java.util.List;

import data.Article;
import data.Comment;
import repository.*;

import org.hibernate.Session;

/**
 * 
 * @author Ferdinand Kaiser, 06.04.08
 *
 */
public class EntityManager {

	
	private Article_DAO article_DAO;
	private Comment_DAO comment_DAO;
	private Session session;
	
	public EntityManager(){
		this.session=HibernateUtil.getSessionFactory().getCurrentSession();
		article_DAO=new Article_DAO(session);
		comment_DAO=new Comment_DAO(session);
	}
	
	public EntityManager(Session session){
		this.session=session;
		article_DAO=new Article_DAO(session);
		comment_DAO=new Comment_DAO(session);
	}
	
	public void setSession(Session session){
		this.session=session;
	}
	
	
	public Comment createAndStoreComment(Long articleId,String text){
		return comment_DAO.createAndStore(articleId, text);
	}
	
	public void updateComment(Long id, String text,boolean deleted){
		comment_DAO.update(id, text,deleted);
	}
	
	public Article createAndStoreArticle(String title, String text){
		return article_DAO.createAndStore(title, text);
	}
	
	public void updateArticle(Long id,String title, String text,boolean deleted){
		article_DAO.update(id, title, text, deleted);
	}
	
	public List<Article> getArticles(){
		return article_DAO.getList();
	}

	public Article getArticleById(Long id){
		return article_DAO.getById(id);
	}
	
	public void  deleteCommentFromArticle(Long articleId, Long commentId){
		article_DAO.deleteComment(articleId, commentId);
	}
}
