package repository;


import java.util.List;
import java.util.Date;
import org.hibernate.Session;
import data.Article;
import data.Comment;

/**
 * 
 * @author Ferdinand Kaiser, 06.04.08
 *
 */
public class Article_DAO {
	
	private Session session;
	
	private Article_DAO(){
		
	}
	
	public Article_DAO(Session session){
		this.session=session;
	}
	
	public Article createAndStore(String title, String text){
		Article article=new Article();
		article.setText(text);
		article.setTitle(title);
		article.setCreationDate(new Date());
		article.setLastEdit(new Date());
		article.setDeleted(false);
		session.save(article);
		return article;
	}

	public void update(Long id,String title, String text,boolean deleted){
		Article article=(Article) session.load(Article.class,id);
		article.setText(text);
		article.setTitle(title);
		article.setLastEdit(new Date());
		article.setDeleted(deleted);
		session.update(article);
	}
	
	public List<Article> getList(){
		List<Article> result=session.createQuery("from Article").list();
		return result;
	}
	
	public Article getById(Long id){
		return (Article)session.load(Article.class,id);
	}

	public void deleteComment(Long articleId, Long commentId){
		Article article=(Article) session.load(Article.class,articleId);
		Comment comment=(Comment) session.load(Comment.class,commentId);
		article.getComments().remove(comment);
		session.update(article);
	}
	
}
