package repository;


import java.util.Date;
import org.hibernate.Session;
import data.Article;
import data.Comment;

/**
 * 
 * @author Ferdinand Kaiser, 06.04.08
 *
 */
public class Comment_DAO {
	
	private Session session;
	
	private Comment_DAO(){
		
	}
	
	public Comment_DAO(Session session){
		this.session=session;
	}	

	public Comment createAndStore(Long articleId,String text){
		Comment comment=new Comment();
		comment.setText(text);
		comment.setCreationDate(new Date());
		comment.setLastEdit(new Date());
		comment.setDeleted(false);
		((Article) session.load(Article.class,articleId)).getComments().add(comment);
		session.save(comment);
		return comment;
	}

	public void update(Long id, String text,boolean deleted){
		Comment comment=(Comment) session.load(Comment.class,id);
		comment.setText(text);
		comment.setLastEdit(new Date());
		comment.setDeleted(deleted);
		session.update(comment);
	}	
	
	public Comment getById(Long id){
		return (Comment)session.load(Article.class,id);
	}	
	
}
