package test;

import repository.HibernateUtil;
import org.hibernate.*;
import data.*;
import java.util.Date;

/**
 *  Collection Mapping  - ok
 *  Inheritance Mapping - ?
 *  Association Mapping - ???
 * 
 * 
 * @author Ferdinand Kaiser, 06.04.08
 *
 */
public class MappingTest {
	
	
	private static void showArticle(Article article){
		System.out.println();
		System.out.println("----"+article.getTitle()+"----");
		System.out.println("Created "+article.getCreationDate()+" Last Edit "+article.getLastEdit());
		System.out.println("Deleted "+article.isDeleted());
		System.out.println(article.getText());
		System.out.println("----Comments----");
		try{
			for(Comment comment:article.getComments()){
				System.out.println(comment.getText());
			}
		}
		catch(NullPointerException ex){
			System.out.println("No Comments.");
		}
		System.out.println();
	}
	

	public static void main(String[] args)
	{
		Session session=HibernateUtil.getSessionFactory().getCurrentSession();
		session.beginTransaction();

		// Adding a new User
		User user=new User();
		user.setFirstName("Adam");
		user.setLastName("Bird");
		user.setEmailAddress("adam.bird@foo.bar");
		user.setNickName("abi");
		user.setPassword("secret");
		user.setDeleted(false);
		session.save(user);
		
		//Adding Article
		Article article=new Article();		
		article.setTitle("Ava Adore");
		article.setText("The Smashing Pumpkings");
		article.setCreationDate(new Date());
		article.setLastEdit(article.getCreationDate());
		article.setDeleted(false);
		session.save(article);
		
		showArticle(article);
		Comment comment=new Comment();
		comment.setText("I need some Done Kebap.");
		comment.setCreationDate(new Date());
		comment.setLastEdit(comment.getCreationDate());
		comment.setDeleted(false);

		//Add comment to Article
		article.getComments().add(comment);
		//Add comment to DB
		session.save(comment);
		
		comment=new Comment();
		comment.setText("Schmecken lassen.");
		comment.setCreationDate(new Date());
		comment.setLastEdit(comment.getCreationDate());
		comment.setDeleted(false);
		
		article.getComments().add(comment);
		session.save(comment);
		
		showArticle(article);
		
		session.getTransaction().commit();
		
		// ------------------------------------------
		
		
		session=HibernateUtil.getSessionFactory().getCurrentSession();
		session.beginTransaction();
		
		// Retrieve Object
		article= (Article) session.load(Article.class,new Long(1));
		article.setText("The Smashing Pumpkings. Music for rainy days.");
		
		session.update(article);
		showArticle(article);
		
		session.getTransaction().commit();
	
	
	
	}
	
	
	
}
